/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.updatesreceivers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.facilities.TelegramHttpClientBuilder;
import org.telegram.telegrambots.meta.api.methods.updates.GetUpdates;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.generics.BackOff;
import org.telegram.telegrambots.meta.generics.BotOptions;
import org.telegram.telegrambots.meta.generics.BotSession;
import org.telegram.telegrambots.meta.generics.LongPollingBot;
import org.telegram.telegrambots.meta.generics.UpdatesHandler;
import org.telegram.telegrambots.meta.generics.UpdatesReader;
import org.telegram.telegrambots.updatesreceivers.ExponentialBackOff;

public class DefaultBotSession
implements BotSession {
    private static final Logger log = LoggerFactory.getLogger(DefaultBotSession.class);
    private AtomicBoolean running = new AtomicBoolean(false);
    private final ConcurrentLinkedDeque<Update> receivedUpdates = new ConcurrentLinkedDeque();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private ReaderThread readerThread;
    private HandlerThread handlerThread;
    private LongPollingBot callback;
    private String token;
    private int lastReceivedUpdate = 0;
    private DefaultBotOptions options;
    private UpdatesSupplier updatesSupplier;

    @Override
    public synchronized void start() {
        if (this.running.get()) {
            throw new IllegalStateException("Session already running");
        }
        this.running.set(true);
        this.lastReceivedUpdate = 0;
        this.readerThread = new ReaderThread(this.updatesSupplier, this);
        this.readerThread.setName(this.callback.getBotUsername() + " Telegram Connection");
        this.readerThread.start();
        this.handlerThread = new HandlerThread();
        this.handlerThread.setName(this.callback.getBotUsername() + " Telegram Executor");
        this.handlerThread.start();
    }

    @Override
    public synchronized void stop() {
        if (!this.running.get()) {
            throw new IllegalStateException("Session already stopped");
        }
        this.running.set(false);
        if (this.readerThread != null) {
            this.readerThread.interrupt();
        }
        if (this.handlerThread != null) {
            this.handlerThread.interrupt();
        }
        if (this.callback != null) {
            this.callback.onClosing();
        }
    }

    public void setUpdatesSupplier(UpdatesSupplier updatesSupplier) {
        this.updatesSupplier = updatesSupplier;
    }

    @Override
    public void setOptions(BotOptions options) {
        if (this.options != null) {
            throw new InvalidParameterException("BotOptions has already been set");
        }
        this.options = (DefaultBotOptions)options;
    }

    @Override
    public void setToken(String token) {
        if (this.token != null) {
            throw new InvalidParameterException("Token has already been set");
        }
        this.token = token;
    }

    @Override
    public void setCallback(LongPollingBot callback) {
        if (this.callback != null) {
            throw new InvalidParameterException("Callback has already been set");
        }
        this.callback = callback;
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    private List<Update> getUpdateList() {
        ArrayList<Update> updates = new ArrayList<Update>();
        Iterator<Update> it = this.receivedUpdates.iterator();
        while (it.hasNext()) {
            updates.add(it.next());
            it.remove();
        }
        return updates;
    }

    private class HandlerThread
    extends Thread
    implements UpdatesHandler {
        private HandlerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setPriority(1);
            while (DefaultBotSession.this.running.get()) {
                try {
                    List updates = DefaultBotSession.this.getUpdateList();
                    if (updates.isEmpty()) {
                        ConcurrentLinkedDeque concurrentLinkedDeque = DefaultBotSession.this.receivedUpdates;
                        synchronized (concurrentLinkedDeque) {
                            DefaultBotSession.this.receivedUpdates.wait();
                            updates = DefaultBotSession.this.getUpdateList();
                            if (updates.isEmpty()) {
                                continue;
                            }
                        }
                    }
                    DefaultBotSession.this.callback.onUpdatesReceived(updates);
                }
                catch (InterruptedException e) {
                    log.debug(e.getLocalizedMessage(), e);
                    this.interrupt();
                }
                catch (Exception e) {
                    log.error(e.getLocalizedMessage(), e);
                }
            }
            log.debug("Handler thread has being closed");
        }
    }

    public static interface UpdatesSupplier {
        public List<Update> getUpdates() throws Exception;
    }

    private class ReaderThread
    extends Thread
    implements UpdatesReader {
        private final UpdatesSupplier updatesSupplier;
        private final Object lock;
        private CloseableHttpClient httpclient;
        private BackOff backOff;
        private RequestConfig requestConfig;

        public ReaderThread(UpdatesSupplier updatesSupplier, Object lock) {
            this.updatesSupplier = Optional.ofNullable(updatesSupplier).orElse(this::getUpdatesFromServer);
            this.lock = lock;
        }

        @Override
        public synchronized void start() {
            this.httpclient = TelegramHttpClientBuilder.build(DefaultBotSession.this.options);
            this.requestConfig = DefaultBotSession.this.options.getRequestConfig();
            this.backOff = DefaultBotSession.this.options.getBackOff();
            if (this.backOff == null) {
                this.backOff = new ExponentialBackOff();
            }
            if (this.requestConfig == null) {
                this.requestConfig = RequestConfig.copy(RequestConfig.custom().build()).setSocketTimeout(75000).setConnectTimeout(75000).setConnectionRequestTimeout(75000).build();
            }
            super.start();
        }

        @Override
        public void interrupt() {
            if (this.httpclient != null) {
                try {
                    this.httpclient.close();
                }
                catch (IOException e) {
                    log.warn(e.getLocalizedMessage(), e);
                }
            }
            super.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setPriority(1);
            while (DefaultBotSession.this.running.get()) {
                Object object = this.lock;
                synchronized (object) {
                    block19: {
                        if (DefaultBotSession.this.running.get()) {
                            Object object2;
                            try {
                                List<Update> updates = this.updatesSupplier.getUpdates();
                                if (updates.isEmpty()) {
                                    this.lock.wait(500L);
                                    break block19;
                                }
                                updates.removeIf(x -> x.getUpdateId() < DefaultBotSession.this.lastReceivedUpdate);
                                DefaultBotSession.this.lastReceivedUpdate = updates.parallelStream().map(Update::getUpdateId).max(Integer::compareTo).orElse(0);
                                DefaultBotSession.this.receivedUpdates.addAll(updates);
                                object2 = DefaultBotSession.this.receivedUpdates;
                                synchronized (object2) {
                                    DefaultBotSession.this.receivedUpdates.notifyAll();
                                }
                            }
                            catch (InterruptedException e) {
                                if (!DefaultBotSession.this.running.get()) {
                                    DefaultBotSession.this.receivedUpdates.clear();
                                }
                                log.debug(e.getLocalizedMessage(), e);
                                this.interrupt();
                            }
                            catch (Exception global) {
                                log.error(global.getLocalizedMessage(), global);
                                try {
                                    object2 = this.lock;
                                    synchronized (object2) {
                                        this.lock.wait(this.backOff.nextBackOffMillis());
                                    }
                                }
                                catch (InterruptedException e) {
                                    if (!DefaultBotSession.this.running.get()) {
                                        DefaultBotSession.this.receivedUpdates.clear();
                                    }
                                    log.debug(e.getLocalizedMessage(), e);
                                    this.interrupt();
                                }
                            }
                        }
                    }
                }
            }
            log.debug("Reader thread has being closed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        private List<Update> getUpdatesFromServer() throws IOException {
            block20: {
                GetUpdates request = GetUpdates.builder().limit(DefaultBotSession.this.options.getGetUpdatesLimit()).timeout(DefaultBotSession.this.options.getGetUpdatesTimeout()).offset(DefaultBotSession.this.lastReceivedUpdate + 1).build();
                if (DefaultBotSession.this.options.getAllowedUpdates() != null) {
                    request.setAllowedUpdates(DefaultBotSession.this.options.getAllowedUpdates());
                }
                String url = DefaultBotSession.this.options.getBaseUrl() + DefaultBotSession.this.token + "/" + "getupdates";
                HttpPost httpPost = new HttpPost(url);
                httpPost.addHeader("charset", StandardCharsets.UTF_8.name());
                httpPost.setConfig(this.requestConfig);
                httpPost.setEntity(new StringEntity(DefaultBotSession.this.objectMapper.writeValueAsString(request), ContentType.APPLICATION_JSON));
                try (CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpPost, DefaultBotSession.this.options.getHttpContext());){
                    String responseContent222 = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
                    if (response.getStatusLine().getStatusCode() >= 500) {
                        log.warn(responseContent222);
                        Object object = this.lock;
                        synchronized (object) {
                            this.lock.wait(500L);
                            break block20;
                        }
                    }
                    try {
                        Serializable updates = request.deserializeResponse(responseContent222);
                        this.backOff.reset();
                        Serializable serializable = updates;
                        return serializable;
                    }
                    catch (JSONException e) {
                        log.error("Error deserializing update: " + responseContent222, e);
                    }
                }
                catch (InvalidObjectException | SocketException | TelegramApiRequestException e2) {
                    log.error(e2.getLocalizedMessage(), e2);
                }
                catch (SocketTimeoutException e3) {
                    log.info(e3.getLocalizedMessage(), e3);
                }
                catch (InterruptedException e4) {
                    log.info(e4.getLocalizedMessage(), e4);
                    this.interrupt();
                }
                catch (InternalError e5) {
                    if (e5.getCause() instanceof InvocationTargetException) {
                        Throwable cause = e5.getCause().getCause();
                        log.error(cause.getLocalizedMessage(), cause);
                    }
                    throw e5;
                }
            }
            return Collections.emptyList();
        }
    }
}

