/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.User;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class GetMe
extends BotApiMethod<User> {
    public static final String PATH = "getme";

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public User deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<User> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<User>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error getting me", result);
        }
        catch (IOException e2) {
            throw new TelegramApiRequestException("Unable to deserialize response", e2);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
    }

    public static GetMeBuilder builder() {
        return new GetMeBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetMe)) {
            return false;
        }
        GetMe other = (GetMe)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetMe;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "GetMe()";
    }

    public static class GetMeBuilder {
        GetMeBuilder() {
        }

        public GetMe build() {
            return new GetMe();
        }

        public String toString() {
            return "GetMe.GetMeBuilder()";
        }
    }
}

