/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.updates;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetWebhook
extends BotApiMethod<Boolean> {
    public static final String PATH = "setWebhook";
    public static final String URL_FIELD = "url";
    public static final String CERTIFICATE_FIELD = "certificate";
    public static final String MAXCONNECTIONS_FIELD = "max_connections";
    public static final String ALLOWEDUPDATES_FIELD = "allowed_updates";
    public static final String IPADDRESS_FIELD = "ip_address";
    public static final String DROPPENDINGUPDATES_FIELD = "drop_pending_updates";
    @JsonProperty(value="url")
    @NonNull
    private String url;
    @JsonProperty(value="certificate")
    private InputFile certificate;
    @JsonProperty(value="max_connections")
    private Integer maxConnections;
    @JsonProperty(value="allowed_updates")
    private List<String> allowedUpdates;
    @JsonProperty(value="ip_address")
    private String ipAddress;
    @JsonProperty(value="drop_pending_updates")
    private Boolean dropPendingUpdates;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<Boolean> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error setting webhook", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.url == null || this.url.isEmpty()) {
            throw new TelegramApiValidationException("URL parameter can't be empty", this);
        }
        if (this.certificate != null && !this.certificate.isNew()) {
            throw new TelegramApiValidationException("Certificate parameter must be a new file to upload", this);
        }
    }

    public static SetWebhookBuilder builder() {
        return new SetWebhookBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetWebhook)) {
            return false;
        }
        SetWebhook other = (SetWebhook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxConnections = this.getMaxConnections();
        Integer other$maxConnections = other.getMaxConnections();
        if (this$maxConnections == null ? other$maxConnections != null : !((Object)this$maxConnections).equals(other$maxConnections)) {
            return false;
        }
        Boolean this$dropPendingUpdates = this.getDropPendingUpdates();
        Boolean other$dropPendingUpdates = other.getDropPendingUpdates();
        if (this$dropPendingUpdates == null ? other$dropPendingUpdates != null : !((Object)this$dropPendingUpdates).equals(other$dropPendingUpdates)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        InputFile this$certificate = this.getCertificate();
        InputFile other$certificate = other.getCertificate();
        if (this$certificate == null ? other$certificate != null : !((Object)this$certificate).equals(other$certificate)) {
            return false;
        }
        List<String> this$allowedUpdates = this.getAllowedUpdates();
        List<String> other$allowedUpdates = other.getAllowedUpdates();
        if (this$allowedUpdates == null ? other$allowedUpdates != null : !((Object)this$allowedUpdates).equals(other$allowedUpdates)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        return !(this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetWebhook;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxConnections = this.getMaxConnections();
        result = result * 59 + ($maxConnections == null ? 43 : ((Object)$maxConnections).hashCode());
        Boolean $dropPendingUpdates = this.getDropPendingUpdates();
        result = result * 59 + ($dropPendingUpdates == null ? 43 : ((Object)$dropPendingUpdates).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        InputFile $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : ((Object)$certificate).hashCode());
        List<String> $allowedUpdates = this.getAllowedUpdates();
        result = result * 59 + ($allowedUpdates == null ? 43 : ((Object)$allowedUpdates).hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        return result;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    public InputFile getCertificate() {
        return this.certificate;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public List<String> getAllowedUpdates() {
        return this.allowedUpdates;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Boolean getDropPendingUpdates() {
        return this.dropPendingUpdates;
    }

    @JsonProperty(value="url")
    public void setUrl(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
    }

    @JsonProperty(value="certificate")
    public void setCertificate(InputFile certificate) {
        this.certificate = certificate;
    }

    @JsonProperty(value="max_connections")
    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    @JsonProperty(value="allowed_updates")
    public void setAllowedUpdates(List<String> allowedUpdates) {
        this.allowedUpdates = allowedUpdates;
    }

    @JsonProperty(value="ip_address")
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @JsonProperty(value="drop_pending_updates")
    public void setDropPendingUpdates(Boolean dropPendingUpdates) {
        this.dropPendingUpdates = dropPendingUpdates;
    }

    public String toString() {
        return "SetWebhook(url=" + this.getUrl() + ", certificate=" + this.getCertificate() + ", maxConnections=" + this.getMaxConnections() + ", allowedUpdates=" + this.getAllowedUpdates() + ", ipAddress=" + this.getIpAddress() + ", dropPendingUpdates=" + this.getDropPendingUpdates() + ")";
    }

    public SetWebhook(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
    }

    public SetWebhook() {
    }

    public SetWebhook(@NonNull String url, InputFile certificate, Integer maxConnections, List<String> allowedUpdates, String ipAddress, Boolean dropPendingUpdates) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
        this.certificate = certificate;
        this.maxConnections = maxConnections;
        this.allowedUpdates = allowedUpdates;
        this.ipAddress = ipAddress;
        this.dropPendingUpdates = dropPendingUpdates;
    }

    public static class SetWebhookBuilder {
        private String url;
        private InputFile certificate;
        private Integer maxConnections;
        private ArrayList<String> allowedUpdates;
        private String ipAddress;
        private Boolean dropPendingUpdates;

        SetWebhookBuilder() {
        }

        @JsonProperty(value="url")
        public SetWebhookBuilder url(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this;
        }

        @JsonProperty(value="certificate")
        public SetWebhookBuilder certificate(InputFile certificate) {
            this.certificate = certificate;
            return this;
        }

        @JsonProperty(value="max_connections")
        public SetWebhookBuilder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public SetWebhookBuilder allowedUpdate(String allowedUpdate) {
            if (this.allowedUpdates == null) {
                this.allowedUpdates = new ArrayList();
            }
            this.allowedUpdates.add(allowedUpdate);
            return this;
        }

        @JsonProperty(value="allowed_updates")
        public SetWebhookBuilder allowedUpdates(Collection<? extends String> allowedUpdates) {
            if (allowedUpdates == null) {
                throw new NullPointerException("allowedUpdates cannot be null");
            }
            if (this.allowedUpdates == null) {
                this.allowedUpdates = new ArrayList();
            }
            this.allowedUpdates.addAll(allowedUpdates);
            return this;
        }

        public SetWebhookBuilder clearAllowedUpdates() {
            if (this.allowedUpdates != null) {
                this.allowedUpdates.clear();
            }
            return this;
        }

        @JsonProperty(value="ip_address")
        public SetWebhookBuilder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        @JsonProperty(value="drop_pending_updates")
        public SetWebhookBuilder dropPendingUpdates(Boolean dropPendingUpdates) {
            this.dropPendingUpdates = dropPendingUpdates;
            return this;
        }

        public SetWebhook build() {
            List<String> allowedUpdates;
            switch (this.allowedUpdates == null ? 0 : this.allowedUpdates.size()) {
                case 0: {
                    allowedUpdates = Collections.emptyList();
                    break;
                }
                case 1: {
                    allowedUpdates = Collections.singletonList(this.allowedUpdates.get(0));
                    break;
                }
                default: {
                    allowedUpdates = Collections.unmodifiableList(new ArrayList<String>(this.allowedUpdates));
                }
            }
            return new SetWebhook(this.url, this.certificate, this.maxConnections, allowedUpdates, this.ipAddress, this.dropPendingUpdates);
        }

        public String toString() {
            return "SetWebhook.SetWebhookBuilder(url=" + this.url + ", certificate=" + this.certificate + ", maxConnections=" + this.maxConnections + ", allowedUpdates=" + this.allowedUpdates + ", ipAddress=" + this.ipAddress + ", dropPendingUpdates=" + this.dropPendingUpdates + ")";
        }
    }
}

