/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.webapp;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.webapp.SentWebAppMessage;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class AnswerWebAppQuery
extends BotApiMethod<SentWebAppMessage> {
    public static final String PATH = "answerWebAppQuery";
    private static final String WEBAPPQUERYID_FIELD = "web_app_query_id";
    private static final String RESULT_FIELD = "result";
    @JsonProperty(value="web_app_query_id")
    @NonNull
    private String webAppQueryId;
    @JsonProperty(value="result")
    @NonNull
    private InlineQueryResult queryResult;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.webAppQueryId.isEmpty()) {
            throw new TelegramApiValidationException("WebAppQueryId can't be empty", this);
        }
        this.queryResult.validate();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public SentWebAppMessage deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<SentWebAppMessage> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<SentWebAppMessage>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error answering web app query query", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    public static AnswerWebAppQueryBuilder builder() {
        return new AnswerWebAppQueryBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnswerWebAppQuery)) {
            return false;
        }
        AnswerWebAppQuery other = (AnswerWebAppQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$webAppQueryId = this.getWebAppQueryId();
        String other$webAppQueryId = other.getWebAppQueryId();
        if (this$webAppQueryId == null ? other$webAppQueryId != null : !this$webAppQueryId.equals(other$webAppQueryId)) {
            return false;
        }
        InlineQueryResult this$queryResult = this.getQueryResult();
        InlineQueryResult other$queryResult = other.getQueryResult();
        return !(this$queryResult == null ? other$queryResult != null : !this$queryResult.equals(other$queryResult));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnswerWebAppQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $webAppQueryId = this.getWebAppQueryId();
        result = result * 59 + ($webAppQueryId == null ? 43 : $webAppQueryId.hashCode());
        InlineQueryResult $queryResult = this.getQueryResult();
        result = result * 59 + ($queryResult == null ? 43 : $queryResult.hashCode());
        return result;
    }

    @NonNull
    public String getWebAppQueryId() {
        return this.webAppQueryId;
    }

    @NonNull
    public InlineQueryResult getQueryResult() {
        return this.queryResult;
    }

    @JsonProperty(value="web_app_query_id")
    public void setWebAppQueryId(@NonNull String webAppQueryId) {
        if (webAppQueryId == null) {
            throw new NullPointerException("webAppQueryId is marked non-null but is null");
        }
        this.webAppQueryId = webAppQueryId;
    }

    @JsonProperty(value="result")
    public void setQueryResult(@NonNull InlineQueryResult queryResult) {
        if (queryResult == null) {
            throw new NullPointerException("queryResult is marked non-null but is null");
        }
        this.queryResult = queryResult;
    }

    public String toString() {
        return "AnswerWebAppQuery(webAppQueryId=" + this.getWebAppQueryId() + ", queryResult=" + this.getQueryResult() + ")";
    }

    public AnswerWebAppQuery() {
    }

    public AnswerWebAppQuery(@NonNull String webAppQueryId, @NonNull InlineQueryResult queryResult) {
        if (webAppQueryId == null) {
            throw new NullPointerException("webAppQueryId is marked non-null but is null");
        }
        if (queryResult == null) {
            throw new NullPointerException("queryResult is marked non-null but is null");
        }
        this.webAppQueryId = webAppQueryId;
        this.queryResult = queryResult;
    }

    public static class AnswerWebAppQueryBuilder {
        private String webAppQueryId;
        private InlineQueryResult queryResult;

        AnswerWebAppQueryBuilder() {
        }

        @JsonProperty(value="web_app_query_id")
        public AnswerWebAppQueryBuilder webAppQueryId(@NonNull String webAppQueryId) {
            if (webAppQueryId == null) {
                throw new NullPointerException("webAppQueryId is marked non-null but is null");
            }
            this.webAppQueryId = webAppQueryId;
            return this;
        }

        @JsonProperty(value="result")
        public AnswerWebAppQueryBuilder queryResult(@NonNull InlineQueryResult queryResult) {
            if (queryResult == null) {
                throw new NullPointerException("queryResult is marked non-null but is null");
            }
            this.queryResult = queryResult;
            return this;
        }

        public AnswerWebAppQuery build() {
            return new AnswerWebAppQuery(this.webAppQueryId, this.queryResult);
        }

        public String toString() {
            return "AnswerWebAppQuery.AnswerWebAppQueryBuilder(webAppQueryId=" + this.webAppQueryId + ", queryResult=" + this.queryResult + ")";
        }
    }
}

