/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.commands.scope.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.objects.commands.scope.BotCommandScope;
import org.telegram.telegrambots.meta.api.objects.commands.scope.BotCommandScopeAllChatAdministrators;
import org.telegram.telegrambots.meta.api.objects.commands.scope.BotCommandScopeAllGroupChats;
import org.telegram.telegrambots.meta.api.objects.commands.scope.BotCommandScopeAllPrivateChats;
import org.telegram.telegrambots.meta.api.objects.commands.scope.BotCommandScopeChat;
import org.telegram.telegrambots.meta.api.objects.commands.scope.BotCommandScopeChatAdministrators;
import org.telegram.telegrambots.meta.api.objects.commands.scope.BotCommandScopeChatMember;
import org.telegram.telegrambots.meta.api.objects.commands.scope.BotCommandScopeDefault;

public class BotCommandScopeDeserializer
extends StdDeserializer<BotCommandScope> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public BotCommandScopeDeserializer() {
        this((Class<?>)null);
    }

    private BotCommandScopeDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public BotCommandScope deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String type;
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        switch (type = node.has("Type") ? node.get("type").asText() : "") {
            case "default": {
                return this.objectMapper.readValue(node.toString(), new TypeReference<BotCommandScopeDefault>(){});
            }
            case "all_private_chats": {
                return this.objectMapper.readValue(node.toString(), new TypeReference<BotCommandScopeAllPrivateChats>(){});
            }
            case "all_group_chats": {
                return this.objectMapper.readValue(node.toString(), new TypeReference<BotCommandScopeAllGroupChats>(){});
            }
            case "all_chat_administrators": {
                return this.objectMapper.readValue(node.toString(), new TypeReference<BotCommandScopeAllChatAdministrators>(){});
            }
            case "chat": {
                return this.objectMapper.readValue(node.toString(), new TypeReference<BotCommandScopeChat>(){});
            }
            case "chat_administrators": {
                return this.objectMapper.readValue(node.toString(), new TypeReference<BotCommandScopeChatAdministrators>(){});
            }
            case "chat_member": {
                return this.objectMapper.readValue(node.toString(), new TypeReference<BotCommandScopeChatMember>(){});
            }
        }
        return null;
    }
}

