/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.menubutton;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.menubutton.MenuButton;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class GetChatMenuButton
extends BotApiMethod<MenuButton> {
    public static final String PATH = "getChatMenuButton";
    private static final String CHATID_FIELD = "chat_id";
    @JsonProperty(value="chat_id")
    private String chatId;

    @Override
    public void validate() throws TelegramApiValidationException {
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public MenuButton deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<MenuButton> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<MenuButton>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error getting chat menu button query", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    public static GetChatMenuButtonBuilder builder() {
        return new GetChatMenuButtonBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetChatMenuButton)) {
            return false;
        }
        GetChatMenuButton other = (GetChatMenuButton)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetChatMenuButton;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        return result;
    }

    public String getChatId() {
        return this.chatId;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public String toString() {
        return "GetChatMenuButton(chatId=" + this.getChatId() + ")";
    }

    public GetChatMenuButton() {
    }

    public GetChatMenuButton(String chatId) {
        this.chatId = chatId;
    }

    public static class GetChatMenuButtonBuilder {
        private String chatId;

        GetChatMenuButtonBuilder() {
        }

        @JsonProperty(value="chat_id")
        public GetChatMenuButtonBuilder chatId(String chatId) {
            this.chatId = chatId;
            return this;
        }

        public GetChatMenuButton build() {
            return new GetChatMenuButton(this.chatId);
        }

        public String toString() {
            return "GetChatMenuButton.GetChatMenuButtonBuilder(chatId=" + this.chatId + ")";
        }
    }
}

