/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.menubutton;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.menubutton.MenuButton;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetChatMenuButton
extends BotApiMethod<Boolean> {
    public static final String PATH = "setChatMenuButton";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MENUBUTTON_FIELD = "menu_button";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="menu_button")
    private MenuButton menuButton;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.menuButton != null) {
            this.menuButton.validate();
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<Boolean> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error setting chat menu button query", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    public static SetChatMenuButtonBuilder builder() {
        return new SetChatMenuButtonBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetChatMenuButton)) {
            return false;
        }
        SetChatMenuButton other = (SetChatMenuButton)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        MenuButton this$menuButton = this.getMenuButton();
        MenuButton other$menuButton = other.getMenuButton();
        return !(this$menuButton == null ? other$menuButton != null : !((Object)this$menuButton).equals(other$menuButton));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetChatMenuButton;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        MenuButton $menuButton = this.getMenuButton();
        result = result * 59 + ($menuButton == null ? 43 : ((Object)$menuButton).hashCode());
        return result;
    }

    public String getChatId() {
        return this.chatId;
    }

    public MenuButton getMenuButton() {
        return this.menuButton;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @JsonProperty(value="menu_button")
    public void setMenuButton(MenuButton menuButton) {
        this.menuButton = menuButton;
    }

    public String toString() {
        return "SetChatMenuButton(chatId=" + this.getChatId() + ", menuButton=" + this.getMenuButton() + ")";
    }

    public SetChatMenuButton() {
    }

    public SetChatMenuButton(String chatId, MenuButton menuButton) {
        this.chatId = chatId;
        this.menuButton = menuButton;
    }

    public static class SetChatMenuButtonBuilder {
        private String chatId;
        private MenuButton menuButton;

        SetChatMenuButtonBuilder() {
        }

        @JsonProperty(value="chat_id")
        public SetChatMenuButtonBuilder chatId(String chatId) {
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="menu_button")
        public SetChatMenuButtonBuilder menuButton(MenuButton menuButton) {
            this.menuButton = menuButton;
            return this;
        }

        public SetChatMenuButton build() {
            return new SetChatMenuButton(this.chatId, this.menuButton);
        }

        public String toString() {
            return "SetChatMenuButton.SetChatMenuButtonBuilder(chatId=" + this.chatId + ", menuButton=" + this.menuButton + ")";
        }
    }
}

