/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaAnimation;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaAudio;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaDocument;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SendMediaGroup
extends PartialBotApiMethod<ArrayList<Message>> {
    public static final String PATH = "sendMediaGroup";
    public static final String CHATID_FIELD = "chat_id";
    public static final String MEDIA_FIELD = "media";
    public static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    public static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    public static final String ALLOWSENDINGWITHOUTREPLY_FIELD = "allow_sending_without_reply";
    public static final String PROTECTCONTENT_FIELD = "protect_content";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="media")
    @NonNull
    private List<InputMedia> medias;
    @JsonProperty(value="reply_to_message_id")
    private Integer replyToMessageId;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="allow_sending_without_reply")
    private Boolean allowSendingWithoutReply;
    private Boolean protectContent;

    public void enableNotification() {
        this.disableNotification = false;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public ArrayList<Message> deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<ArrayList<Message>> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<ArrayList<Message>>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error sending media group", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.medias == null || this.medias.isEmpty()) {
            throw new TelegramApiValidationException("Media parameter can't be empty", this);
        }
        if (this.medias.size() < 2 || this.medias.size() > 10) {
            throw new TelegramApiValidationException("Number of media should be between 2 and 10", this);
        }
        for (InputMedia inputMedia : this.medias) {
            if (inputMedia == null) {
                throw new TelegramApiValidationException("Media parameter can not be empty", this);
            }
            if (inputMedia instanceof InputMediaAnimation) {
                throw new TelegramApiValidationException("Media parameter can not be an Animation", this);
            }
            inputMedia.validate();
        }
        if (this.medias.stream().anyMatch(x -> x instanceof InputMediaAudio)) {
            if (!this.medias.stream().allMatch(x -> x instanceof InputMediaAudio)) {
                throw new TelegramApiValidationException("Media parameter containing Audio can not have other types", this);
            }
        } else if (this.medias.stream().anyMatch(x -> x instanceof InputMediaDocument) && !this.medias.stream().allMatch(x -> x instanceof InputMediaDocument)) {
            throw new TelegramApiValidationException("Media parameter containing Document can not have other types", this);
        }
    }

    public static SendMediaGroupBuilder builder() {
        return new SendMediaGroupBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendMediaGroup)) {
            return false;
        }
        SendMediaGroup other = (SendMediaGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$replyToMessageId = this.getReplyToMessageId();
        Integer other$replyToMessageId = other.getReplyToMessageId();
        if (this$replyToMessageId == null ? other$replyToMessageId != null : !((Object)this$replyToMessageId).equals(other$replyToMessageId)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        List<InputMedia> this$medias = this.getMedias();
        List<InputMedia> other$medias = other.getMedias();
        return !(this$medias == null ? other$medias != null : !((Object)this$medias).equals(other$medias));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendMediaGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $replyToMessageId = this.getReplyToMessageId();
        result = result * 59 + ($replyToMessageId == null ? 43 : ((Object)$replyToMessageId).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        List<InputMedia> $medias = this.getMedias();
        result = result * 59 + ($medias == null ? 43 : ((Object)$medias).hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public List<InputMedia> getMedias() {
        return this.medias;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    public Boolean getProtectContent() {
        return this.protectContent;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="media")
    public void setMedias(@NonNull List<InputMedia> medias) {
        if (medias == null) {
            throw new NullPointerException("medias is marked non-null but is null");
        }
        this.medias = medias;
    }

    @JsonProperty(value="reply_to_message_id")
    public void setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
    }

    @JsonProperty(value="disable_notification")
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @JsonProperty(value="allow_sending_without_reply")
    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    public String toString() {
        return "SendMediaGroup(chatId=" + this.getChatId() + ", medias=" + this.getMedias() + ", replyToMessageId=" + this.getReplyToMessageId() + ", disableNotification=" + this.getDisableNotification() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ", protectContent=" + this.getProtectContent() + ")";
    }

    public SendMediaGroup(@NonNull String chatId, @NonNull List<InputMedia> medias) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (medias == null) {
            throw new NullPointerException("medias is marked non-null but is null");
        }
        this.chatId = chatId;
        this.medias = medias;
    }

    public SendMediaGroup() {
    }

    public SendMediaGroup(@NonNull String chatId, @NonNull List<InputMedia> medias, Integer replyToMessageId, Boolean disableNotification, Boolean allowSendingWithoutReply, Boolean protectContent) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (medias == null) {
            throw new NullPointerException("medias is marked non-null but is null");
        }
        this.chatId = chatId;
        this.medias = medias;
        this.replyToMessageId = replyToMessageId;
        this.disableNotification = disableNotification;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
        this.protectContent = protectContent;
    }

    public static class SendMediaGroupBuilder {
        private String chatId;
        private List<InputMedia> medias;
        private Integer replyToMessageId;
        private Boolean disableNotification;
        private Boolean allowSendingWithoutReply;
        private Boolean protectContent;

        SendMediaGroupBuilder() {
        }

        @JsonProperty(value="chat_id")
        public SendMediaGroupBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="media")
        public SendMediaGroupBuilder medias(@NonNull List<InputMedia> medias) {
            if (medias == null) {
                throw new NullPointerException("medias is marked non-null but is null");
            }
            this.medias = medias;
            return this;
        }

        @JsonProperty(value="reply_to_message_id")
        public SendMediaGroupBuilder replyToMessageId(Integer replyToMessageId) {
            this.replyToMessageId = replyToMessageId;
            return this;
        }

        @JsonProperty(value="disable_notification")
        public SendMediaGroupBuilder disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        @JsonProperty(value="allow_sending_without_reply")
        public SendMediaGroupBuilder allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return this;
        }

        public SendMediaGroupBuilder protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return this;
        }

        public SendMediaGroup build() {
            return new SendMediaGroup(this.chatId, this.medias, this.replyToMessageId, this.disableNotification, this.allowSendingWithoutReply, this.protectContent);
        }

        public String toString() {
            return "SendMediaGroup.SendMediaGroupBuilder(chatId=" + this.chatId + ", medias=" + this.medias + ", replyToMessageId=" + this.replyToMessageId + ", disableNotification=" + this.disableNotification + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ", protectContent=" + this.protectContent + ")";
        }
    }
}

