/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.updatesreceivers;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.generics.Webhook;
import org.telegram.telegrambots.meta.generics.WebhookBot;
import org.telegram.telegrambots.updatesreceivers.DefaultExceptionMapper;
import org.telegram.telegrambots.updatesreceivers.RestApi;

public class DefaultWebhook
implements Webhook {
    private String keystoreServerFile;
    private String keystoreServerPwd;
    private String internalUrl;
    private final RestApi restApi = new RestApi();

    @Override
    public void setInternalUrl(String internalUrl) {
        this.internalUrl = internalUrl;
    }

    @Override
    public void setKeyStore(String keyStore, String keyStorePassword) throws TelegramApiException {
        this.keystoreServerFile = keyStore;
        this.keystoreServerPwd = keyStorePassword;
        DefaultWebhook.validateServerKeystoreFile(keyStore);
    }

    @Override
    public void registerWebhook(WebhookBot callback) {
        this.restApi.registerCallback(callback);
    }

    @Override
    public void startServer() throws TelegramApiException {
        HttpServer grizzlyServer;
        ResourceConfig rc = new ResourceConfig();
        rc.register(this.restApi);
        rc.register((Class)JacksonFeature.class);
        rc.register((Class)DefaultExceptionMapper.class);
        if (this.keystoreServerFile != null && this.keystoreServerPwd != null) {
            SSLContextConfigurator sslContext = new SSLContextConfigurator();
            sslContext.setKeyStoreFile(this.keystoreServerFile);
            sslContext.setKeyStorePass(this.keystoreServerPwd);
            grizzlyServer = GrizzlyHttpServerFactory.createHttpServer(this.getBaseURI(), rc, true, new SSLEngineConfigurator(sslContext).setClientMode(false).setNeedClientAuth(false));
        } else {
            grizzlyServer = GrizzlyHttpServerFactory.createHttpServer(this.getBaseURI(), rc);
        }
        try {
            grizzlyServer.start();
        }
        catch (IOException e) {
            throw new TelegramApiException("Error starting webhook server", e);
        }
    }

    private URI getBaseURI() {
        return URI.create(this.internalUrl);
    }

    private static void validateServerKeystoreFile(String keyStore) throws TelegramApiException {
        File file = new File(keyStore);
        if (!file.exists() || !file.canRead()) {
            throw new TelegramApiException("Can't find or access server keystore file.");
        }
    }
}

