/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.updatesreceivers;

import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.generics.Webhook;
import org.telegram.telegrambots.meta.generics.WebhookBot;

public class ServerlessWebhook
implements Webhook {
    private static final Logger log = LoggerFactory.getLogger(ServerlessWebhook.class);
    private final ConcurrentHashMap<String, WebhookBot> callbacks = new ConcurrentHashMap();

    public BotApiMethod<?> updateReceived(String botPath, Update update) throws TelegramApiValidationException {
        if (this.callbacks.containsKey(botPath)) {
            try {
                BotApiMethod<?> response = this.callbacks.get(botPath).onWebhookUpdateReceived(update);
                if (response != null) {
                    response.validate();
                }
                return response;
            }
            catch (TelegramApiValidationException e) {
                log.error(e.getLocalizedMessage(), e);
                throw e;
            }
        }
        throw new NoSuchElementException(String.format("Callback '%s' not exist", botPath));
    }

    @Override
    public void startServer() throws TelegramApiException {
    }

    @Override
    public void registerWebhook(WebhookBot callback) {
        this.callbacks.putIfAbsent(callback.getBotPath(), callback);
    }

    @Override
    public void setInternalUrl(String internalUrl) {
        throw new UnsupportedOperationException("Not implemented for Serverless Webhook");
    }

    @Override
    public void setKeyStore(String keyStore, String keyStorePassword) throws TelegramApiException {
        throw new UnsupportedOperationException("Not implemented for Serverless Webhook");
    }
}

