/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.updatesreceivers;

import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.generics.WebhookBot;

@Path(value="callback")
public class RestApi {
    private static final Logger log = LoggerFactory.getLogger(RestApi.class);
    private final ConcurrentHashMap<String, WebhookBot> callbacks = new ConcurrentHashMap();

    public void registerCallback(WebhookBot callback) {
        if (!this.callbacks.containsKey(callback.getBotPath())) {
            this.callbacks.put(callback.getBotPath(), callback);
        }
    }

    @POST
    @Path(value="/{botPath}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateReceived(@PathParam(value="botPath") String botPath, Update update) {
        if (this.callbacks.containsKey(botPath)) {
            try {
                BotApiMethod response = this.callbacks.get(botPath).onWebhookUpdateReceived(update);
                if (response != null) {
                    response.validate();
                }
                return Response.ok((Object)response).build();
            }
            catch (TelegramApiValidationException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                return Response.serverError().build();
            }
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{botPath}")
    @Produces(value={"application/json"})
    public String testReceived(@PathParam(value="botPath") String botPath) {
        if (this.callbacks.containsKey(botPath)) {
            return "Hi there " + botPath + "!";
        }
        return "Callback not found for " + botPath;
    }
}

