/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.menubutton.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.objects.menubutton.MenuButton;
import org.telegram.telegrambots.meta.api.objects.menubutton.MenuButtonCommands;
import org.telegram.telegrambots.meta.api.objects.menubutton.MenuButtonDefault;
import org.telegram.telegrambots.meta.api.objects.menubutton.MenuButtonWebApp;

public class MenuButtonDeserializer
extends StdDeserializer<MenuButton> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public MenuButtonDeserializer() {
        this((Class<?>)null);
    }

    public MenuButtonDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public MenuButton deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        switch (node.get("type").asText()) {
            case "default": {
                return this.objectMapper.readValue(node.toString(), new TypeReference<MenuButtonDefault>(){});
            }
            case "web_app": {
                return this.objectMapper.readValue(node.toString(), new TypeReference<MenuButtonWebApp>(){});
            }
            case "commands": {
                return this.objectMapper.readValue(node.toString(), new TypeReference<MenuButtonCommands>(){});
            }
        }
        return null;
    }
}

