/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.replykeyboard;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardRow;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class ReplyKeyboardMarkup
implements ReplyKeyboard {
    private static final String KEYBOARD_FIELD = "keyboard";
    private static final String RESIZEKEYBOARD_FIELD = "resize_keyboard";
    private static final String ONETIMEKEYBOARD_FIELD = "one_time_keyboard";
    private static final String SELECTIVE_FIELD = "selective";
    private static final String INPUTFIELDPLACEHOLDER_FIELD = "input_field_placeholder";
    private static final String ISPERSISTENT_FIELD = "is_persistent";
    @JsonProperty(value="keyboard")
    @NonNull
    private List<KeyboardRow> keyboard;
    @JsonProperty(value="resize_keyboard")
    private Boolean resizeKeyboard;
    @JsonProperty(value="one_time_keyboard")
    private Boolean oneTimeKeyboard;
    @JsonProperty(value="selective")
    private Boolean selective;
    @JsonProperty(value="input_field_placeholder")
    private String inputFieldPlaceholder;
    @JsonProperty(value="is_persistent")
    private Boolean isPersistent;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.keyboard == null) {
            throw new TelegramApiValidationException("Keyboard parameter can't be null", this);
        }
        if (this.inputFieldPlaceholder != null && (this.inputFieldPlaceholder.length() < 1 || this.inputFieldPlaceholder.length() > 64)) {
            throw new TelegramApiValidationException("InputFieldPlaceholder must be between 1 and 64 characters", this);
        }
        for (KeyboardRow keyboardButtons : this.keyboard) {
            keyboardButtons.validate();
        }
    }

    public static ReplyKeyboardMarkupBuilder builder() {
        return new ReplyKeyboardMarkupBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplyKeyboardMarkup)) {
            return false;
        }
        ReplyKeyboardMarkup other = (ReplyKeyboardMarkup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$resizeKeyboard = this.getResizeKeyboard();
        Boolean other$resizeKeyboard = other.getResizeKeyboard();
        if (this$resizeKeyboard == null ? other$resizeKeyboard != null : !((Object)this$resizeKeyboard).equals(other$resizeKeyboard)) {
            return false;
        }
        Boolean this$oneTimeKeyboard = this.getOneTimeKeyboard();
        Boolean other$oneTimeKeyboard = other.getOneTimeKeyboard();
        if (this$oneTimeKeyboard == null ? other$oneTimeKeyboard != null : !((Object)this$oneTimeKeyboard).equals(other$oneTimeKeyboard)) {
            return false;
        }
        Boolean this$selective = this.getSelective();
        Boolean other$selective = other.getSelective();
        if (this$selective == null ? other$selective != null : !((Object)this$selective).equals(other$selective)) {
            return false;
        }
        Boolean this$isPersistent = this.getIsPersistent();
        Boolean other$isPersistent = other.getIsPersistent();
        if (this$isPersistent == null ? other$isPersistent != null : !((Object)this$isPersistent).equals(other$isPersistent)) {
            return false;
        }
        List<KeyboardRow> this$keyboard = this.getKeyboard();
        List<KeyboardRow> other$keyboard = other.getKeyboard();
        if (this$keyboard == null ? other$keyboard != null : !((Object)this$keyboard).equals(other$keyboard)) {
            return false;
        }
        String this$inputFieldPlaceholder = this.getInputFieldPlaceholder();
        String other$inputFieldPlaceholder = other.getInputFieldPlaceholder();
        return !(this$inputFieldPlaceholder == null ? other$inputFieldPlaceholder != null : !this$inputFieldPlaceholder.equals(other$inputFieldPlaceholder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReplyKeyboardMarkup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $resizeKeyboard = this.getResizeKeyboard();
        result = result * 59 + ($resizeKeyboard == null ? 43 : ((Object)$resizeKeyboard).hashCode());
        Boolean $oneTimeKeyboard = this.getOneTimeKeyboard();
        result = result * 59 + ($oneTimeKeyboard == null ? 43 : ((Object)$oneTimeKeyboard).hashCode());
        Boolean $selective = this.getSelective();
        result = result * 59 + ($selective == null ? 43 : ((Object)$selective).hashCode());
        Boolean $isPersistent = this.getIsPersistent();
        result = result * 59 + ($isPersistent == null ? 43 : ((Object)$isPersistent).hashCode());
        List<KeyboardRow> $keyboard = this.getKeyboard();
        result = result * 59 + ($keyboard == null ? 43 : ((Object)$keyboard).hashCode());
        String $inputFieldPlaceholder = this.getInputFieldPlaceholder();
        result = result * 59 + ($inputFieldPlaceholder == null ? 43 : $inputFieldPlaceholder.hashCode());
        return result;
    }

    @NonNull
    public List<KeyboardRow> getKeyboard() {
        return this.keyboard;
    }

    public Boolean getResizeKeyboard() {
        return this.resizeKeyboard;
    }

    public Boolean getOneTimeKeyboard() {
        return this.oneTimeKeyboard;
    }

    public Boolean getSelective() {
        return this.selective;
    }

    public String getInputFieldPlaceholder() {
        return this.inputFieldPlaceholder;
    }

    public Boolean getIsPersistent() {
        return this.isPersistent;
    }

    @JsonProperty(value="resize_keyboard")
    public void setResizeKeyboard(Boolean resizeKeyboard) {
        this.resizeKeyboard = resizeKeyboard;
    }

    @JsonProperty(value="one_time_keyboard")
    public void setOneTimeKeyboard(Boolean oneTimeKeyboard) {
        this.oneTimeKeyboard = oneTimeKeyboard;
    }

    @JsonProperty(value="selective")
    public void setSelective(Boolean selective) {
        this.selective = selective;
    }

    @JsonProperty(value="input_field_placeholder")
    public void setInputFieldPlaceholder(String inputFieldPlaceholder) {
        this.inputFieldPlaceholder = inputFieldPlaceholder;
    }

    @JsonProperty(value="is_persistent")
    public void setIsPersistent(Boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    public String toString() {
        return "ReplyKeyboardMarkup(keyboard=" + this.getKeyboard() + ", resizeKeyboard=" + this.getResizeKeyboard() + ", oneTimeKeyboard=" + this.getOneTimeKeyboard() + ", selective=" + this.getSelective() + ", inputFieldPlaceholder=" + this.getInputFieldPlaceholder() + ", isPersistent=" + this.getIsPersistent() + ")";
    }

    public ReplyKeyboardMarkup() {
    }

    public ReplyKeyboardMarkup(@NonNull List<KeyboardRow> keyboard) {
        if (keyboard == null) {
            throw new NullPointerException("keyboard is marked non-null but is null");
        }
        this.keyboard = keyboard;
    }

    public ReplyKeyboardMarkup(@NonNull List<KeyboardRow> keyboard, Boolean resizeKeyboard, Boolean oneTimeKeyboard, Boolean selective, String inputFieldPlaceholder, Boolean isPersistent) {
        if (keyboard == null) {
            throw new NullPointerException("keyboard is marked non-null but is null");
        }
        this.keyboard = keyboard;
        this.resizeKeyboard = resizeKeyboard;
        this.oneTimeKeyboard = oneTimeKeyboard;
        this.selective = selective;
        this.inputFieldPlaceholder = inputFieldPlaceholder;
        this.isPersistent = isPersistent;
    }

    @JsonProperty(value="keyboard")
    public void setKeyboard(@NonNull List<KeyboardRow> keyboard) {
        if (keyboard == null) {
            throw new NullPointerException("keyboard is marked non-null but is null");
        }
        this.keyboard = keyboard;
    }

    public static class ReplyKeyboardMarkupBuilder {
        private ArrayList<KeyboardRow> keyboard;
        private Boolean resizeKeyboard;
        private Boolean oneTimeKeyboard;
        private Boolean selective;
        private String inputFieldPlaceholder;
        private Boolean isPersistent;

        ReplyKeyboardMarkupBuilder() {
        }

        public ReplyKeyboardMarkupBuilder keyboardRow(KeyboardRow keyboardRow) {
            if (this.keyboard == null) {
                this.keyboard = new ArrayList();
            }
            this.keyboard.add(keyboardRow);
            return this;
        }

        @JsonProperty(value="keyboard")
        public ReplyKeyboardMarkupBuilder keyboard(Collection<? extends KeyboardRow> keyboard) {
            if (keyboard == null) {
                throw new NullPointerException("keyboard cannot be null");
            }
            if (this.keyboard == null) {
                this.keyboard = new ArrayList();
            }
            this.keyboard.addAll(keyboard);
            return this;
        }

        public ReplyKeyboardMarkupBuilder clearKeyboard() {
            if (this.keyboard != null) {
                this.keyboard.clear();
            }
            return this;
        }

        @JsonProperty(value="resize_keyboard")
        public ReplyKeyboardMarkupBuilder resizeKeyboard(Boolean resizeKeyboard) {
            this.resizeKeyboard = resizeKeyboard;
            return this;
        }

        @JsonProperty(value="one_time_keyboard")
        public ReplyKeyboardMarkupBuilder oneTimeKeyboard(Boolean oneTimeKeyboard) {
            this.oneTimeKeyboard = oneTimeKeyboard;
            return this;
        }

        @JsonProperty(value="selective")
        public ReplyKeyboardMarkupBuilder selective(Boolean selective) {
            this.selective = selective;
            return this;
        }

        @JsonProperty(value="input_field_placeholder")
        public ReplyKeyboardMarkupBuilder inputFieldPlaceholder(String inputFieldPlaceholder) {
            this.inputFieldPlaceholder = inputFieldPlaceholder;
            return this;
        }

        @JsonProperty(value="is_persistent")
        public ReplyKeyboardMarkupBuilder isPersistent(Boolean isPersistent) {
            this.isPersistent = isPersistent;
            return this;
        }

        public ReplyKeyboardMarkup build() {
            List<KeyboardRow> keyboard;
            switch (this.keyboard == null ? 0 : this.keyboard.size()) {
                case 0: {
                    keyboard = Collections.emptyList();
                    break;
                }
                case 1: {
                    keyboard = Collections.singletonList(this.keyboard.get(0));
                    break;
                }
                default: {
                    keyboard = Collections.unmodifiableList(new ArrayList<KeyboardRow>(this.keyboard));
                }
            }
            return new ReplyKeyboardMarkup(keyboard, this.resizeKeyboard, this.oneTimeKeyboard, this.selective, this.inputFieldPlaceholder, this.isPersistent);
        }

        public String toString() {
            return "ReplyKeyboardMarkup.ReplyKeyboardMarkupBuilder(keyboard=" + this.keyboard + ", resizeKeyboard=" + this.resizeKeyboard + ", oneTimeKeyboard=" + this.oneTimeKeyboard + ", selective=" + this.selective + ", inputFieldPlaceholder=" + this.inputFieldPlaceholder + ", isPersistent=" + this.isPersistent + ")";
        }
    }
}

