/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.bots.commandbot.commands;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.bots.AbsSender;
import org.telegram.telegrambots.bots.commandbot.commands.BotCommand;
import org.telegram.telegrambots.bots.commandbot.commands.ICommandRegistry;

public final class CommandRegistry
implements ICommandRegistry {
    private final Map<String, BotCommand> commandRegistryMap = new HashMap<String, BotCommand>();
    private final boolean allowCommandsWithUsername;
    private final String botUsername;
    private BiConsumer<AbsSender, Message> defaultConsumer;

    public CommandRegistry(boolean allowCommandsWithUsername, String botUsername) {
        this.allowCommandsWithUsername = allowCommandsWithUsername;
        this.botUsername = botUsername;
    }

    @Override
    public void registerDefaultAction(BiConsumer<AbsSender, Message> defaultConsumer) {
        this.defaultConsumer = defaultConsumer;
    }

    @Override
    public final boolean register(BotCommand botCommand) {
        if (this.commandRegistryMap.containsKey(botCommand.getCommandIdentifier())) {
            return false;
        }
        this.commandRegistryMap.put(botCommand.getCommandIdentifier(), botCommand);
        return true;
    }

    @Override
    public final Map<BotCommand, Boolean> registerAll(BotCommand ... botCommands) {
        HashMap<BotCommand, Boolean> resultMap = new HashMap<BotCommand, Boolean>(botCommands.length);
        for (BotCommand botCommand : botCommands) {
            resultMap.put(botCommand, this.register(botCommand));
        }
        return resultMap;
    }

    @Override
    public final boolean deregister(BotCommand botCommand) {
        if (this.commandRegistryMap.containsKey(botCommand.getCommandIdentifier())) {
            this.commandRegistryMap.remove(botCommand.getCommandIdentifier());
            return true;
        }
        return false;
    }

    @Override
    public final Map<BotCommand, Boolean> deregisterAll(BotCommand ... botCommands) {
        HashMap<BotCommand, Boolean> resultMap = new HashMap<BotCommand, Boolean>(botCommands.length);
        for (BotCommand botCommand : botCommands) {
            resultMap.put(botCommand, this.deregister(botCommand));
        }
        return resultMap;
    }

    @Override
    public final Collection<BotCommand> getRegisteredCommands() {
        return this.commandRegistryMap.values();
    }

    @Override
    public final BotCommand getRegisteredCommand(String commandIdentifier) {
        return this.commandRegistryMap.get(commandIdentifier);
    }

    public final boolean executeCommand(AbsSender absSender, Message message) {
        String text;
        if (message.hasText() && (text = message.getText()).startsWith("/")) {
            String commandMessage = text.substring(1);
            String[] commandSplit = commandMessage.split("\\s+");
            String command = this.removeUsernameFromCommandIfNeeded(commandSplit[0]);
            if (this.commandRegistryMap.containsKey(command)) {
                String[] parameters = Arrays.copyOfRange(commandSplit, 1, commandSplit.length);
                this.commandRegistryMap.get(command).execute(absSender, message.getFrom(), message.getChat(), parameters);
                return true;
            }
            if (this.defaultConsumer != null) {
                this.defaultConsumer.accept(absSender, message);
                return true;
            }
        }
        return false;
    }

    private String removeUsernameFromCommandIfNeeded(String command) {
        if (this.allowCommandsWithUsername) {
            return command.replace("@" + this.botUsername, "").trim();
        }
        return command;
    }
}

