/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.bots.commandbot.commands;

import org.telegram.telegrambots.api.objects.Chat;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.api.objects.User;
import org.telegram.telegrambots.bots.AbsSender;
import org.telegram.telegrambots.bots.commandbot.commands.IBotCommand;

public abstract class BotCommand
implements IBotCommand {
    public static final String COMMAND_INIT_CHARACTER = "/";
    public static final String COMMAND_PARAMETER_SEPARATOR_REGEXP = "\\s+";
    private static final int COMMAND_MAX_LENGTH = 32;
    private final String commandIdentifier;
    private final String description;

    public BotCommand(String commandIdentifier, String description) {
        if (commandIdentifier == null || commandIdentifier.isEmpty()) {
            throw new IllegalArgumentException("commandIdentifier for command cannot be null or empty");
        }
        if (commandIdentifier.startsWith(COMMAND_INIT_CHARACTER)) {
            commandIdentifier = commandIdentifier.substring(1);
        }
        if (commandIdentifier.length() + 1 > 32) {
            throw new IllegalArgumentException("commandIdentifier cannot be longer than 32 (including /)");
        }
        this.commandIdentifier = commandIdentifier.toLowerCase();
        this.description = description;
    }

    @Override
    public final String getCommandIdentifier() {
        return this.commandIdentifier;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    public String toString() {
        return "<b>/" + this.getCommandIdentifier() + "</b>\n" + this.getDescription();
    }

    @Override
    public void processMessage(AbsSender absSender, Message message, String[] arguments) {
        this.execute(absSender, message.getFrom(), message.getChat(), arguments);
    }

    public abstract void execute(AbsSender var1, User var2, Chat var3, String[] var4);
}

