/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.extensions.bots.timedbot;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;

public abstract class TimedSendLongPollingBot
extends TelegramLongPollingBot {
    private static final long MANY_CHATS_SEND_INTERVAL = 33L;
    private static final long ONE_CHAT_SEND_INTERVAL = 1000L;
    private static final long CHAT_INACTIVE_INTERVAL = 600000L;
    private final Timer mSendTimer = new Timer(true);
    private final ConcurrentHashMap<Long, MessageQueue> mMessagesMap = new ConcurrentHashMap(32, 0.75f, 1);
    private final ArrayList<MessageQueue> mSendQueues = new ArrayList();
    private final AtomicBoolean mSendRequested = new AtomicBoolean(false);

    protected TimedSendLongPollingBot() {
        this.mSendTimer.schedule((TimerTask)new MessageSenderTask(), 33L, 33L);
    }

    public void finish() {
        this.mSendTimer.cancel();
    }

    public void sendTimed(Long chatId, Object messageRequest) {
        MessageQueue queue = this.mMessagesMap.get(chatId);
        if (queue == null) {
            queue = new MessageQueue(chatId);
            queue.putMessage(messageRequest);
            this.mMessagesMap.put(chatId, queue);
        } else {
            queue.putMessage(messageRequest);
            this.mMessagesMap.putIfAbsent(chatId, queue);
        }
        this.mSendRequested.set(true);
    }

    public abstract void sendMessageCallback(Long var1, Object var2);

    private static class MessageQueue {
        public static final int EMPTY = 0;
        public static final int WAIT = 1;
        public static final int DELETE = 2;
        public static final int GET_MESSAGE = 3;
        private final ConcurrentLinkedQueue<Object> mQueue = new ConcurrentLinkedQueue();
        private final Long mChatId;
        private long mLastSendTime;
        private volatile long mLastPutTime;

        public MessageQueue(Long chatId) {
            this.mChatId = chatId;
        }

        public synchronized void putMessage(Object msg) {
            this.mQueue.add(msg);
            this.mLastPutTime = System.currentTimeMillis();
        }

        public synchronized int getCurrentState(long currentTime) {
            long interval = currentTime - this.mLastSendTime;
            boolean empty = this.mQueue.isEmpty();
            if (!empty && interval > 1000L) {
                return 3;
            }
            if (interval > 600000L) {
                return 2;
            }
            if (empty) {
                return 0;
            }
            return 1;
        }

        public synchronized Object getMessage(long currentTime) {
            this.mLastSendTime = currentTime;
            return this.mQueue.poll();
        }

        public long getPutTime() {
            return this.mLastPutTime;
        }

        public Long getChatId() {
            return this.mChatId;
        }
    }

    private final class MessageSenderTask
    extends TimerTask {
        private MessageSenderTask() {
        }

        @Override
        public void run() {
            if (!TimedSendLongPollingBot.this.mSendRequested.getAndSet(false)) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            TimedSendLongPollingBot.this.mSendQueues.clear();
            boolean processNext = false;
            Iterator it = TimedSendLongPollingBot.this.mMessagesMap.entrySet().iterator();
            while (it.hasNext()) {
                MessageQueue queue = (MessageQueue)it.next().getValue();
                int state = queue.getCurrentState(currentTime);
                if (state == 3) {
                    TimedSendLongPollingBot.this.mSendQueues.add(queue);
                    processNext = true;
                    continue;
                }
                if (state == 1) {
                    processNext = true;
                    continue;
                }
                if (state != 2) continue;
                it.remove();
            }
            if (processNext) {
                TimedSendLongPollingBot.this.mSendRequested.set(true);
            }
            MessageQueue sendQueue = null;
            long oldestPutTime = Long.MAX_VALUE;
            for (int i = 0; i < TimedSendLongPollingBot.this.mSendQueues.size(); ++i) {
                MessageQueue queue = (MessageQueue)TimedSendLongPollingBot.this.mSendQueues.get(i);
                long putTime = queue.getPutTime();
                if (putTime >= oldestPutTime) continue;
                oldestPutTime = putTime;
                sendQueue = queue;
            }
            if (sendQueue == null) {
                return;
            }
            TimedSendLongPollingBot.this.sendMessageCallback(sendQueue.getChatId(), sendQueue.getMessage(currentTime));
        }
    }
}

