/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.extensions.bots.timedbot;

import java.util.ArrayList;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;

public abstract class TimedSendLongPollingBot
extends TelegramLongPollingBot {
    private static final long ONE_CHAT_SEND_INTERVAL = 1000L;
    private static final long CHAT_INACTIVE_INTERVAL = 600000L;
    private final Timer mSendTimer = new Timer(true);
    private final ConcurrentHashMap<Long, MessageQueue> mMessagesMap = new ConcurrentHashMap(32, 0.75f, 1);
    private final ArrayList<MessageQueue> mSendQueues = new ArrayList();
    private final AtomicBoolean mSendRequested = new AtomicBoolean(false);

    public void finish() {
        this.mSendTimer.cancel();
    }

    public void sendTimed(Long chatId, Object messageRequest) {
        MessageQueue queue = this.mMessagesMap.get(chatId);
        if (queue == null) {
            queue = new MessageQueue(chatId);
            queue.putMessage(messageRequest);
            this.mMessagesMap.put(chatId, queue);
        } else {
            queue.putMessage(messageRequest);
            this.mMessagesMap.putIfAbsent(chatId, queue);
        }
        this.mSendRequested.set(true);
    }

    abstract void sendMessageCallback(Long var1, Object var2);

    private static class MessageQueue {
        static final int EMPTY = 0;
        static final int WAIT = 1;
        static final int DELETE = 2;
        static final int GET_MESSAGE = 3;
        private final ConcurrentLinkedQueue<Object> mQueue = new ConcurrentLinkedQueue();
        private final Long mChatId;
        private long mLastSendTime;
        private volatile long mLastPutTime;

        MessageQueue(Long chatId) {
            this.mChatId = chatId;
        }

        synchronized void putMessage(Object msg) {
            this.mQueue.add(msg);
            this.mLastPutTime = System.currentTimeMillis();
        }

        synchronized int getCurrentState(long currentTime) {
            long interval = currentTime - this.mLastSendTime;
            boolean empty = this.mQueue.isEmpty();
            if (!empty && interval > 1000L) {
                return 3;
            }
            if (interval > 600000L) {
                return 2;
            }
            if (empty) {
                return 0;
            }
            return 1;
        }

        synchronized Object getMessage(long currentTime) {
            this.mLastSendTime = currentTime;
            return this.mQueue.poll();
        }

        long getPutTime() {
            return this.mLastPutTime;
        }

        Long getChatId() {
            return this.mChatId;
        }
    }
}

