/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.extensions.bots.commandbot;

import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.extensions.bots.commandbot.commands.CommandRegistry;
import org.telegram.telegrambots.extensions.bots.commandbot.commands.IBotCommand;
import org.telegram.telegrambots.extensions.bots.commandbot.commands.ICommandRegistry;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.bots.AbsSender;

public abstract class TelegramLongPollingCommandBot
extends TelegramLongPollingBot
implements ICommandRegistry {
    private final CommandRegistry commandRegistry;

    public TelegramLongPollingCommandBot() {
        this(new DefaultBotOptions());
    }

    public TelegramLongPollingCommandBot(DefaultBotOptions options) {
        this(options, true);
    }

    public TelegramLongPollingCommandBot(DefaultBotOptions options, boolean allowCommandsWithUsername) {
        super(options);
        this.commandRegistry = new CommandRegistry(allowCommandsWithUsername, this::getBotUsername);
    }

    public final void onUpdateReceived(Update update) {
        Message message;
        if (update.hasMessage() && (message = update.getMessage()).isCommand() && !this.filter(message)) {
            if (!this.commandRegistry.executeCommand((AbsSender)this, message)) {
                this.processInvalidCommandUpdate(update);
            }
            return;
        }
        this.processNonCommandUpdate(update);
    }

    protected void processInvalidCommandUpdate(Update update) {
        this.processNonCommandUpdate(update);
    }

    protected boolean filter(Message message) {
        return false;
    }

    @Override
    public final boolean register(IBotCommand botCommand) {
        return this.commandRegistry.register(botCommand);
    }

    @Override
    public final Map<IBotCommand, Boolean> registerAll(IBotCommand ... botCommands) {
        return this.commandRegistry.registerAll(botCommands);
    }

    @Override
    public final boolean deregister(IBotCommand botCommand) {
        return this.commandRegistry.deregister(botCommand);
    }

    @Override
    public final Map<IBotCommand, Boolean> deregisterAll(IBotCommand ... botCommands) {
        return this.commandRegistry.deregisterAll(botCommands);
    }

    @Override
    public final Collection<IBotCommand> getRegisteredCommands() {
        return this.commandRegistry.getRegisteredCommands();
    }

    @Override
    public void registerDefaultAction(BiConsumer<AbsSender, Message> defaultConsumer) {
        this.commandRegistry.registerDefaultAction(defaultConsumer);
    }

    @Override
    public final IBotCommand getRegisteredCommand(String commandIdentifier) {
        return this.commandRegistry.getRegisteredCommand(commandIdentifier);
    }

    public abstract String getBotUsername();

    public abstract void processNonCommandUpdate(Update var1);
}

