/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.extensions.bots.commandbot;

import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.bots.TelegramWebhookBot;
import org.telegram.telegrambots.extensions.bots.commandbot.CommandBot;
import org.telegram.telegrambots.extensions.bots.commandbot.commands.CommandRegistry;
import org.telegram.telegrambots.extensions.bots.commandbot.commands.IBotCommand;
import org.telegram.telegrambots.extensions.bots.commandbot.commands.ICommandRegistry;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.bots.AbsSender;

public abstract class TelegramWebhookCommandBot
extends TelegramWebhookBot
implements CommandBot,
ICommandRegistry {
    private final CommandRegistry commandRegistry;

    @Deprecated
    public TelegramWebhookCommandBot() {
        this(new DefaultBotOptions());
    }

    @Deprecated
    public TelegramWebhookCommandBot(DefaultBotOptions options) {
        this(options, true);
    }

    @Deprecated
    public TelegramWebhookCommandBot(DefaultBotOptions options, boolean allowCommandsWithUsername) {
        super(options);
        this.commandRegistry = new CommandRegistry(allowCommandsWithUsername, () -> ((TelegramWebhookCommandBot)this).getBotUsername());
    }

    public TelegramWebhookCommandBot(String botToken) {
        this(new DefaultBotOptions(), botToken);
    }

    public TelegramWebhookCommandBot(DefaultBotOptions options, String botToken) {
        this(options, true, botToken);
    }

    public TelegramWebhookCommandBot(DefaultBotOptions options, boolean allowCommandsWithUsername, String botToken) {
        super(options, botToken);
        this.commandRegistry = new CommandRegistry(allowCommandsWithUsername, () -> ((TelegramWebhookCommandBot)this).getBotUsername());
    }

    public BotApiMethod<?> onWebhookUpdateReceived(Update update) {
        Message message;
        if (update.hasMessage() && (message = update.getMessage()).isCommand() && !this.filter(message)) {
            if (!this.commandRegistry.executeCommand((AbsSender)this, message)) {
                this.processInvalidCommandUpdate(update);
            }
            return null;
        }
        this.processNonCommandUpdate(update);
        return null;
    }

    @Override
    public final boolean register(IBotCommand botCommand) {
        return this.commandRegistry.register(botCommand);
    }

    @Override
    public final Map<IBotCommand, Boolean> registerAll(IBotCommand ... botCommands) {
        return this.commandRegistry.registerAll(botCommands);
    }

    @Override
    public final boolean deregister(IBotCommand botCommand) {
        return this.commandRegistry.deregister(botCommand);
    }

    @Override
    public final Map<IBotCommand, Boolean> deregisterAll(IBotCommand ... botCommands) {
        return this.commandRegistry.deregisterAll(botCommands);
    }

    @Override
    public final Collection<IBotCommand> getRegisteredCommands() {
        return this.commandRegistry.getRegisteredCommands();
    }

    @Override
    public void registerDefaultAction(BiConsumer<AbsSender, Message> defaultConsumer) {
        this.commandRegistry.registerDefaultAction(defaultConsumer);
    }

    @Override
    public final IBotCommand getRegisteredCommand(String commandIdentifier) {
        return this.commandRegistry.getRegisteredCommand(commandIdentifier);
    }
}

