/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.extensions.bots.commandbot.commands.helpCommand;

import java.util.Collection;
import org.telegram.telegrambots.extensions.bots.commandbot.commands.IBotCommand;
import org.telegram.telegrambots.extensions.bots.commandbot.commands.ICommandRegistry;
import org.telegram.telegrambots.extensions.bots.commandbot.commands.helpCommand.IManCommand;
import org.telegram.telegrambots.extensions.bots.commandbot.commands.helpCommand.ManCommand;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.Chat;
import org.telegram.telegrambots.meta.api.objects.User;
import org.telegram.telegrambots.meta.bots.AbsSender;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

public class HelpCommand
extends ManCommand {
    private static final String COMMAND_IDENTIFIER = "help";
    private static final String COMMAND_DESCRIPTION = "shows all commands. Use /help [command] for more info";
    private static final String EXTENDED_DESCRIPTION = "This command displays all commands the bot has to offer.\n /help [command] can display deeper information";

    public static String getHelpText(IBotCommand ... botCommands) {
        StringBuilder reply = new StringBuilder();
        for (IBotCommand com : botCommands) {
            reply.append(com.toString()).append(System.lineSeparator()).append(System.lineSeparator());
        }
        return reply.toString();
    }

    public static String getHelpText(Collection<IBotCommand> botCommands) {
        return HelpCommand.getHelpText(botCommands.toArray(new IBotCommand[0]));
    }

    public static String getHelpText(ICommandRegistry registry) {
        return HelpCommand.getHelpText(registry.getRegisteredCommands());
    }

    public static String getManText(IBotCommand command) {
        return IManCommand.class.isInstance(command) ? HelpCommand.getManText((IManCommand)((Object)command)) : command.toString();
    }

    public static String getManText(IManCommand command) {
        return command.toMan();
    }

    public HelpCommand() {
        super(COMMAND_IDENTIFIER, COMMAND_DESCRIPTION, EXTENDED_DESCRIPTION);
    }

    public HelpCommand(String commandIdentifier, String description, String extendedDescription) {
        super(commandIdentifier, description, extendedDescription);
    }

    @Override
    public void execute(AbsSender absSender, User user, Chat chat, String[] arguments) {
        if (ICommandRegistry.class.isInstance(absSender)) {
            ICommandRegistry registry = (ICommandRegistry)absSender;
            if (arguments.length > 0) {
                IBotCommand command = registry.getRegisteredCommand(arguments[0]);
                String reply = HelpCommand.getManText(command);
                try {
                    absSender.execute((BotApiMethod)SendMessage.builder().chatId(chat.getId()).text(reply).parseMode("HTML").build());
                }
                catch (TelegramApiException e) {
                    e.printStackTrace();
                }
            } else {
                String reply = HelpCommand.getHelpText(registry);
                try {
                    absSender.execute((BotApiMethod)SendMessage.builder().chatId(chat.getId()).text(reply).parseMode("HTML").build());
                }
                catch (TelegramApiException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

