/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegraph.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import org.telegram.telegraph.api.TelegraphMethod;
import org.telegram.telegraph.api.objects.Node;
import org.telegram.telegraph.api.objects.Page;
import org.telegram.telegraph.api.objects.TelegraphResponse;
import org.telegram.telegraph.exceptions.TelegraphRequestException;
import org.telegram.telegraph.exceptions.TelegraphValidationException;

public class CreatePage
extends TelegraphMethod<Page> {
    private static final String URL_PATH = "createPage";
    private static final String ACCESS_TOKEN_FIELD = "access_token";
    private static final String TITLE_FIELD = "title";
    private static final String AUTHOR_NAME_FIELD = "author_name";
    private static final String AUTHOR_URL_FIELD = "author_url";
    private static final String CONTENT_FIELD = "content";
    private static final String RETURN_CONTENT_FIELD = "return_content";
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="author_name")
    private String authorName;
    @JsonProperty(value="author_url")
    private String authorUrl;
    @JsonProperty(value="content")
    private List<Node> content;
    @JsonProperty(value="return_content")
    private Boolean returnContent;

    public CreatePage(String accessToken, String title, List<Node> content) {
        this.accessToken = accessToken;
        this.title = title;
        this.content = content;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public CreatePage setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public CreatePage setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public CreatePage setAuthorName(String authorName) {
        this.authorName = authorName;
        return this;
    }

    public String getAuthorUrl() {
        return this.authorUrl;
    }

    public CreatePage setAuthorUrl(String authorUrl) {
        this.authorUrl = authorUrl;
        return this;
    }

    public List<Node> getContent() {
        return this.content;
    }

    public CreatePage setContent(List<Node> content) {
        this.content = content;
        return this;
    }

    public Boolean getReturnContent() {
        return this.returnContent;
    }

    public CreatePage setReturnContent(Boolean returnContent) {
        this.returnContent = returnContent;
        return this;
    }

    @Override
    public void validate() throws TelegraphValidationException {
        if (this.accessToken == null || this.accessToken.isEmpty()) {
            throw new TelegraphValidationException("Parameter Access token is required", this);
        }
        if (this.title == null || this.title.length() < 1 || this.title.length() > 256) {
            throw new TelegraphValidationException("Parameter Title is missing or out of size", this);
        }
        if (this.content == null || this.content.isEmpty()) {
            throw new TelegraphValidationException("Parameter Content is required", this);
        }
        if (this.authorName != null && (this.authorName.length() < 0 || this.authorName.length() > 128)) {
            throw new TelegraphValidationException("Wrong size for Author Name", this);
        }
        if (this.authorUrl != null && (this.authorUrl.length() < 0 || this.authorUrl.length() > 512)) {
            throw new TelegraphValidationException("Wrong size for Author Url", this);
        }
    }

    @Override
    public Page deserializeResponse(String answer) throws TelegraphRequestException {
        try {
            TelegraphResponse result = (TelegraphResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<TelegraphResponse<Page>>(){});
            if (result.getOk().booleanValue()) {
                return (Page)result.getResult();
            }
            throw new TelegraphRequestException("Error creating page", result);
        }
        catch (IOException e) {
            throw new TelegraphRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public String getUrlPath() {
        return URL_PATH;
    }

    public String toString() {
        return "CreatePage{accessToken='" + this.accessToken + '\'' + ", title='" + this.title + '\'' + ", authorName='" + this.authorName + '\'' + ", authorUrl='" + this.authorUrl + '\'' + ", content=" + this.content + ", returnContent=" + this.returnContent + '}';
    }
}

