/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegraph.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import org.telegram.telegraph.api.TelegraphMethod;
import org.telegram.telegraph.api.objects.Account;
import org.telegram.telegraph.api.objects.TelegraphResponse;
import org.telegram.telegraph.exceptions.TelegraphRequestException;
import org.telegram.telegraph.exceptions.TelegraphValidationException;

public class GetAccountInfo
extends TelegraphMethod<Account> {
    private static final String URL_PATH = "getAccountInfo";
    private static final String ACCESS_TOKEN_FIELD = "access_token";
    private static final String FIELDS_FIELD = "fields";
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="fields")
    private List<String> fields;

    public GetAccountInfo(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    @Override
    public void validate() throws TelegraphValidationException {
        if (this.accessToken == null || this.accessToken.isEmpty()) {
            throw new TelegraphValidationException("Parameter Access token is required", this);
        }
        if (this.fields != null && this.fields.isEmpty()) {
            throw new TelegraphValidationException("Fields list is empty", this);
        }
    }

    @Override
    public Account deserializeResponse(String answer) throws TelegraphRequestException {
        try {
            TelegraphResponse result = (TelegraphResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<TelegraphResponse<Account>>(){});
            if (result.getOk().booleanValue()) {
                return (Account)result.getResult();
            }
            throw new TelegraphRequestException("Error getting account information", result);
        }
        catch (IOException e) {
            throw new TelegraphRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public String getUrlPath() {
        return URL_PATH;
    }

    public String toString() {
        return "GetAccountInfo{accessToken='" + this.accessToken + '\'' + ", fields=" + this.fields + '}';
    }
}

