/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegraph;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.telegram.telegraph.TelegraphLogger;

public class TelegraphContext {
    private static final Object lock = new Object();
    private static Injector INJECTOR;
    private static Map<Class, Class> bindings;
    private static Map<Class, Object> instanceBindings;
    private static Map<Class, Class> singletonBindings;

    public static <T> T getInstance(Class<T> type) {
        return (T)TelegraphContext.getInjector().getInstance(type);
    }

    public static <T, S extends T> void register(Class<T> type, Class<S> implementation) {
        if (bindings.containsKey(type)) {
            TelegraphLogger.debug("ApiContext", MessageFormat.format("Class {0} already registered", type.getName()));
        }
        bindings.put(type, implementation);
    }

    public static <T, S extends T> void registerInstance(Class<T> type, S instance) {
        if (instanceBindings.containsKey(type)) {
            TelegraphLogger.debug("ApiContext", MessageFormat.format("Class {0} already registered", type.getName()));
        }
        instanceBindings.put(type, instance);
    }

    public static <T, S extends T> void registerSingleton(Class<T> type, Class<S> implementation) {
        if (singletonBindings.containsKey(type)) {
            TelegraphLogger.debug("ApiContext", MessageFormat.format("Class {0} already registered", type.getName()));
        }
        singletonBindings.put(type, implementation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Injector getInjector() {
        if (INJECTOR == null) {
            Object object = lock;
            synchronized (object) {
                if (INJECTOR == null) {
                    INJECTOR = Guice.createInjector((Module[])new Module[]{new ApiModule()});
                }
            }
        }
        return INJECTOR;
    }

    static {
        bindings = new HashMap<Class, Class>();
        instanceBindings = new HashMap<Class, Object>();
        singletonBindings = new HashMap<Class, Class>();
    }

    private static class ApiModule
    extends AbstractModule {
        private ApiModule() {
        }

        protected void configure() {
            for (Map.Entry binding : bindings.entrySet()) {
                this.bind((Class)binding.getKey()).to((Class)binding.getValue());
            }
            for (Map.Entry binding : singletonBindings.entrySet()) {
                this.bind((Class)binding.getKey()).to((Class)binding.getValue()).in(Singleton.class);
            }
            for (Map.Entry binding : instanceBindings.entrySet()) {
                this.bind((Class)binding.getKey()).toInstance(binding.getValue());
            }
        }
    }
}

