/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegraph.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import org.telegram.telegraph.api.TelegraphMethod;
import org.telegram.telegraph.api.objects.Page;
import org.telegram.telegraph.api.objects.TelegraphResponse;
import org.telegram.telegraph.exceptions.TelegraphRequestException;
import org.telegram.telegraph.exceptions.TelegraphValidationException;

public class GetPage
extends TelegraphMethod<Page> {
    private static final String URL_PATH = "getPage";
    private static final String PATH_FIELD = "path";
    private static final String RETURN_CONTENT_FIELD = "return_content";
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="return_content")
    private Boolean returnContent;

    public GetPage(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public GetPage setPath(String path) {
        this.path = path;
        return this;
    }

    public Boolean getReturnContent() {
        return this.returnContent;
    }

    public GetPage setReturnContent(Boolean returnContent) {
        this.returnContent = returnContent;
        return this;
    }

    @Override
    public void validate() throws TelegraphValidationException {
        if (this.path == null || this.path.isEmpty()) {
            throw new TelegraphValidationException("Parameter Path field is required", this);
        }
    }

    @Override
    public Page deserializeResponse(String answer) throws TelegraphRequestException {
        try {
            TelegraphResponse result = (TelegraphResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<TelegraphResponse<Page>>(){});
            if (result.getOk().booleanValue()) {
                return (Page)result.getResult();
            }
            throw new TelegraphRequestException("Error getting page", result);
        }
        catch (IOException e) {
            throw new TelegraphRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public String getUrlPath() {
        return URL_PATH;
    }

    public String toString() {
        return "GetPage{path='" + this.path + '\'' + ", returnContent=" + this.returnContent + '}';
    }
}

