/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegraph.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import org.telegram.telegraph.api.TelegraphMethod;
import org.telegram.telegraph.api.objects.Account;
import org.telegram.telegraph.api.objects.TelegraphResponse;
import org.telegram.telegraph.exceptions.TelegraphRequestException;
import org.telegram.telegraph.exceptions.TelegraphValidationException;

public class CreateAccount
extends TelegraphMethod<Account> {
    private static final String URL_PATH = "createAccount";
    private static final String SHORT_NAME_FIELD = "short_name";
    private static final String AUTHOR_NAME_FIELD = "author_name";
    private static final String AUTHOR_URL_FIELD = "author_url";
    @JsonProperty(value="short_name")
    private String shortName;
    @JsonProperty(value="author_name")
    private String authorName;
    @JsonProperty(value="author_url")
    private String authorUrl;

    public CreateAccount(String shortName) {
        this.shortName = shortName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public CreateAccount setShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public CreateAccount setAuthorName(String authorName) {
        this.authorName = authorName;
        return this;
    }

    public String getAuthorUrl() {
        return this.authorUrl;
    }

    public CreateAccount setAuthorUrl(String authorUrl) {
        this.authorUrl = authorUrl;
        return this;
    }

    @Override
    public void validate() throws TelegraphValidationException {
        if (this.shortName == null || this.shortName.length() < 1 || this.shortName.length() > 32) {
            throw new TelegraphValidationException("Wrong parameter Short Name", this);
        }
        if (this.authorName != null && (this.authorName.length() < 0 || this.authorName.length() > 128)) {
            throw new TelegraphValidationException("Wrong size for Author Name", this);
        }
        if (this.authorUrl != null && (this.authorUrl.length() < 0 || this.authorUrl.length() > 512)) {
            throw new TelegraphValidationException("Wrong size for Author Url", this);
        }
    }

    @Override
    public Account deserializeResponse(String answer) throws TelegraphRequestException {
        try {
            TelegraphResponse result = (TelegraphResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<TelegraphResponse<Account>>(){});
            if (result.getOk().booleanValue()) {
                return (Account)result.getResult();
            }
            throw new TelegraphRequestException("Error creating account", result);
        }
        catch (IOException e) {
            throw new TelegraphRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public String getUrlPath() {
        return URL_PATH;
    }

    public String toString() {
        return "CreateAccount{shortName='" + this.shortName + '\'' + ", authorName='" + this.authorName + '\'' + ", authorUrl='" + this.authorUrl + '\'' + '}';
    }
}

