/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegraph.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import org.telegram.telegraph.api.TelegraphMethod;
import org.telegram.telegraph.api.objects.PageList;
import org.telegram.telegraph.api.objects.TelegraphResponse;
import org.telegram.telegraph.exceptions.TelegraphRequestException;
import org.telegram.telegraph.exceptions.TelegraphValidationException;

public class GetPageList
extends TelegraphMethod<PageList> {
    private static final String URL_PATH = "getPageList";
    private static final String ACCESS_TOKEN_FIELD = "access_token";
    private static final String OFFSET_FIELD = "offset";
    private static final String LIMIT_FIELD = "limit";
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="offset")
    private Integer offset;
    @JsonProperty(value="limit")
    private Integer limit;

    public GetPageList(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public GetPageList setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public GetPageList setOffset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public GetPageList setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public void validate() throws TelegraphValidationException {
        if (this.accessToken == null || this.accessToken.isEmpty()) {
            throw new TelegraphValidationException("Parameter Access token is required", this);
        }
        if (this.offset != null && (this.offset < 0 || this.offset > 200)) {
            throw new TelegraphValidationException("Parameter offset out of range", this);
        }
    }

    @Override
    public PageList deserializeResponse(String answer) throws TelegraphRequestException {
        try {
            TelegraphResponse result = (TelegraphResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<TelegraphResponse<PageList>>(){});
            if (result.getOk().booleanValue()) {
                return (PageList)result.getResult();
            }
            throw new TelegraphRequestException("Error getting page list", result);
        }
        catch (IOException e) {
            throw new TelegraphRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public String getUrlPath() {
        return URL_PATH;
    }

    public String toString() {
        return "GetPageList{accessToken='" + this.accessToken + '\'' + ", offset=" + this.offset + ", limit=" + this.limit + '}';
    }
}

