/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegraph.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import org.telegram.telegraph.api.TelegraphMethod;
import org.telegram.telegraph.api.objects.PageViews;
import org.telegram.telegraph.api.objects.TelegraphResponse;
import org.telegram.telegraph.exceptions.TelegraphRequestException;
import org.telegram.telegraph.exceptions.TelegraphValidationException;

public class GetViews
extends TelegraphMethod<PageViews> {
    private static final String URL_PATH = "getViews";
    private static final String PATH_FIELD = "path";
    private static final String YEAR_FIELD = "year";
    private static final String MONTH_FIELD = "month";
    private static final String DAY_FIELD = "day";
    private static final String HOUR_FIELD = "hour";
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="year")
    private Integer year;
    @JsonProperty(value="month")
    private Integer month;
    @JsonProperty(value="day")
    private Integer day;
    @JsonProperty(value="hour")
    private Integer hour;

    public GetViews(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public GetViews setPath(String path) {
        this.path = path;
        return this;
    }

    public Integer getYear() {
        return this.year;
    }

    public GetViews setYear(Integer year) {
        this.year = year;
        return this;
    }

    public Integer getMonth() {
        return this.month;
    }

    public GetViews setMonth(Integer month) {
        this.month = month;
        return this;
    }

    public Integer getDay() {
        return this.day;
    }

    public GetViews setDay(Integer day) {
        this.day = day;
        return this;
    }

    public Integer getHour() {
        return this.hour;
    }

    public GetViews setHour(Integer hour) {
        this.hour = hour;
        return this;
    }

    @Override
    public void validate() throws TelegraphValidationException {
        if (this.path == null || this.path.isEmpty()) {
            throw new TelegraphValidationException("Parameter Path is required", this);
        }
        if (this.year != null && (this.year < 2000 || this.year > 2100)) {
            throw new TelegraphValidationException("Parameter year out of range", this);
        }
        if (this.month != null && this.year == null) {
            throw new TelegraphValidationException("Parameter year is required when month is present", this);
        }
        if (this.month != null && (this.month < 1 || this.month > 12)) {
            throw new TelegraphValidationException("Parameter month out of range", this);
        }
        if (this.day != null && this.month == null) {
            throw new TelegraphValidationException("Parameter month is required when day is present", this);
        }
        if (this.day != null && (this.day < 1 || this.day > 31)) {
            throw new TelegraphValidationException("Parameter day out of range", this);
        }
        if (this.hour != null && this.day == null) {
            throw new TelegraphValidationException("Parameter day is required when hour is present", this);
        }
        if (this.hour != null && (this.hour < 0 || this.hour > 24)) {
            throw new TelegraphValidationException("Parameter hour out of range", this);
        }
    }

    @Override
    public PageViews deserializeResponse(String answer) throws TelegraphRequestException {
        try {
            TelegraphResponse result = (TelegraphResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<TelegraphResponse<PageViews>>(){});
            if (result.getOk().booleanValue()) {
                return (PageViews)result.getResult();
            }
            throw new TelegraphRequestException("Error getting views", result);
        }
        catch (IOException e) {
            throw new TelegraphRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public String getUrlPath() {
        return URL_PATH;
    }

    public String toString() {
        return "GetViews{path='" + this.path + '\'' + ", year=" + this.year + ", month=" + this.month + ", day=" + this.day + ", hour=" + this.hour + '}';
    }
}

