/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegraph.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import org.telegram.telegraph.api.TelegraphMethod;
import org.telegram.telegraph.api.objects.Account;
import org.telegram.telegraph.api.objects.TelegraphResponse;
import org.telegram.telegraph.exceptions.TelegraphRequestException;
import org.telegram.telegraph.exceptions.TelegraphValidationException;

public class RevokeAccessToken
extends TelegraphMethod<Account> {
    private static final String URL_PATH = "revokeAccessToken";
    private static final String ACCESS_TOKEN_FIELD = "access_token";
    @JsonProperty(value="access_token")
    private String accessToken;

    public RevokeAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public RevokeAccessToken setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Override
    public void validate() throws TelegraphValidationException {
        if (this.accessToken == null || this.accessToken.isEmpty()) {
            throw new TelegraphValidationException("Parameter Access token is required", this);
        }
    }

    @Override
    public Account deserializeResponse(String answer) throws TelegraphRequestException {
        try {
            TelegraphResponse result = (TelegraphResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<TelegraphResponse<Account>>(){});
            if (result.getOk().booleanValue()) {
                return (Account)result.getResult();
            }
            throw new TelegraphRequestException("Error revoking token", result);
        }
        catch (IOException e) {
            throw new TelegraphRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public String getUrlPath() {
        return URL_PATH;
    }

    public String toString() {
        return "RevokeAccessToken{accessToken='" + this.accessToken + '\'' + '}';
    }
}

