/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegraph.executors;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.telegram.telegraph.ExecutorOptions;
import org.telegram.telegraph.api.TelegraphMethod;
import org.telegram.telegraph.api.TelegraphObject;
import org.telegram.telegraph.exceptions.TelegraphException;
import org.telegram.telegraph.exceptions.TelegraphRequestException;
import org.telegram.telegraph.executors.TelegraphExecutor;

public class DefaultTelegraphExecutor
implements TelegraphExecutor {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private volatile CloseableHttpClient httpclient = HttpClientBuilder.create().setSSLHostnameVerifier(new NoopHostnameVerifier()).setConnectionTimeToLive(70L, TimeUnit.SECONDS).setMaxConnTotal(100).build();
    private volatile RequestConfig requestConfig;

    @Inject
    public DefaultTelegraphExecutor(ExecutorOptions options) {
        this.requestConfig = options.getRequestConfig();
    }

    @Override
    public <T extends TelegraphObject> T execute(TelegraphMethod<T> method) throws TelegraphException {
        String responseContent;
        try {
            String url = "https://api.telegra.ph/" + method.getUrlPath();
            HttpPost httppost = new HttpPost(url);
            httppost.setConfig(this.requestConfig);
            httppost.addHeader("charset", StandardCharsets.UTF_8.name());
            httppost.addHeader("Content-Type", "application/json");
            httppost.setEntity(new StringEntity(this.objectMapper.writeValueAsString(method), ContentType.APPLICATION_JSON));
            try (CloseableHttpResponse response = this.httpclient.execute(httppost);){
                HttpEntity ht = response.getEntity();
                BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                responseContent = EntityUtils.toString((HttpEntity)buf, StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            throw new TelegraphRequestException("Unable to execute " + method.getUrlPath() + " method", e);
        }
        return method.deserializeResponse(responseContent);
    }
}

