/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegraph.jsonutilities;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.telegram.telegraph.api.objects.Node;
import org.telegram.telegraph.api.objects.NodeElement;
import org.telegram.telegraph.api.objects.NodeText;

public class NodeDeserializer
extends StdDeserializer<Node> {
    public NodeDeserializer() {
        super(Node.class);
    }

    @Override
    public Node deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        Iterator<Object> it;
        ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(jsonParser);
        if (node instanceof TextNode) {
            return new NodeText(node.asText());
        }
        JsonNode childrenNode = node.get("children");
        JsonNode tagNode = node.get("tag");
        JsonNode attrsNode = node.get("attrs");
        NodeElement element = new NodeElement();
        element.setTag(tagNode.asText());
        if (attrsNode != null && attrsNode instanceof ObjectNode) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            it = attrsNode.fieldNames();
            while (it.hasNext()) {
                String field = (String)it.next();
                attributes.put(field, attrsNode.get(field).asText());
            }
            element.setAttrs(attributes);
        }
        if (childrenNode != null && childrenNode instanceof ArrayNode) {
            ArrayList<Node> childNodes = new ArrayList<Node>();
            it = childrenNode.elements();
            while (it.hasNext()) {
                childNodes.add(mapper.treeToValue((TreeNode)it.next(), Node.class));
            }
            element.setChildren(childNodes);
        }
        return element;
    }
}

