/*
 * Decompiled with CFR 0.152.
 */
package org.tenidwa.collections.utils;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.BiFunction;

public final class TransitiveMap<K, V2>
extends ForwardingMap<K, V2> {
    private final transient Map<K, V2> map;

    public <V1> TransitiveMap(Map<K, V1> base, BiFunction<K, V1, V2> function) {
        this.map = TransitiveMap.createMap(base, function);
    }

    private static <K, V1, V2> Map<K, V2> createMap(Map<K, V1> base, BiFunction<K, V1, V2> function) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<K, V1> e : base.entrySet()) {
            builder.put(e.getKey(), function.apply(e.getKey(), e.getValue()));
        }
        return builder.build();
    }

    protected Map<K, V2> delegate() {
        return this.map;
    }
}

