/*
 * Decompiled with CFR 0.152.
 */
package org.tenidwa.collections.utils;

import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiFunction;

public final class CartesianProduct<A, B, R>
extends ForwardingSet<R> {
    private final transient Set<A> one;
    private final transient Set<B> two;
    private final transient BiFunction<A, B, R> function;
    private transient Set<R> result;

    public CartesianProduct(Set<A> one, Set<B> two, BiFunction<A, B, R> function) {
        this.one = one;
        this.two = two;
        this.function = function;
    }

    protected Set<R> delegate() {
        if (this.result == null) {
            this.result = this.multiplication();
        }
        return this.result;
    }

    private Set<R> multiplication() {
        LinkedHashSet<R> answer = new LinkedHashSet<R>(this.one.size() * this.two.size());
        for (A left : this.one) {
            for (B right : this.two) {
                R element = this.function.apply(left, right);
                if (answer.contains(element)) {
                    throw new IllegalStateException(String.format("Cartesian product result contains duplicated element %s", element));
                }
                answer.add(element);
            }
        }
        return ImmutableSet.copyOf(answer);
    }
}

