/*
 * Decompiled with CFR 0.152.
 */
package org.tenidwa.collections.utils;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class AugmentedMap<K, V>
extends ForwardingMap<K, V> {
    private final transient Map<K, V> delegate;

    public AugmentedMap(Map<K, V> base, Set<? extends K> keys, Function<K, V> augmentation) {
        this.delegate = AugmentedMap.createDelegate(base, keys, augmentation);
    }

    private static <K, V> ImmutableMap<K, V> createDelegate(Map<K, V> base, Set<? extends K> keys, Function<K, V> augmentation) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(base);
        keys.stream().filter(key -> !base.containsKey(key)).forEach(key -> builder.put(key, augmentation.apply(key)));
        return builder.build();
    }

    protected Map<K, V> delegate() {
        return this.delegate;
    }
}

