/*
 * Decompiled with CFR 0.152.
 */
package org.tenidwa.collections.utils;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class ContentMap<K, C, V>
implements Map<K, V> {
    private final transient ImmutableMap<C, V> map;
    private final transient Function<K, C> function;
    private final transient Map<K, V> original;

    public ContentMap(ImmutableMap<K, V> base, Function<K, C> function) {
        this.function = function;
        this.map = this.mapContentToValues(base);
        this.original = base;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.map.containsKey(this.key(o));
    }

    @Override
    public boolean containsValue(Object o) {
        return this.map.containsValue(o);
    }

    @Override
    public V get(Object o) {
        return (V)this.map.get(this.key(o));
    }

    @Override
    @Deprecated
    public V put(K k, V v) {
        throw new UnsupportedOperationException("Put operation is not supported");
    }

    @Override
    @Deprecated
    public V remove(Object o) {
        throw new UnsupportedOperationException("Remove operation is not supported");
    }

    @Override
    @Deprecated
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException("Put all operation is not supported");
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException("Clear operation is not supported");
    }

    @Override
    public Set<K> keySet() {
        return ImmutableSet.copyOf(this.original.keySet());
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return ImmutableSet.copyOf(this.original.entrySet());
    }

    private C key(Object o) {
        return this.function.apply(o);
    }

    private ImmutableMap<C, V> mapContentToValues(ImmutableMap<K, V> base) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : base.entrySet()) {
            builder.put(this.key(entry.getKey()), entry.getValue());
        }
        return builder.build();
    }
}

