/*
 * Decompiled with CFR 0.152.
 */
package org.tendiwa.maven.gitversioninsert;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

final class FileWithReplaceTokens {
    private final Path absolutePath;

    FileWithReplaceTokens(Path pathToFile) {
        if (!pathToFile.toFile().exists()) {
            throw new IllegalArgumentException("File " + pathToFile + " doesn't exist");
        }
        this.absolutePath = pathToFile.toAbsolutePath();
    }

    public void replaceToken(String token, String replacement) {
        Charset charset = StandardCharsets.UTF_8;
        try {
            String content = new String(Files.readAllBytes(this.absolutePath), charset).replace(token, replacement);
            Files.write(this.absolutePath, content.getBytes(charset), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

