/*
 * Decompiled with CFR 0.152.
 */
package org.tenkiv.physikal.core;

import java.util.Collection;
import javax.measure.Quantity;
import javax.measure.Unit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tenkiv.physikal.core.OperatorsKt;
import org.tenkiv.physikal.core.TypeKt;
import tec.uom.se.ComparableQuantity;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aK\u0010\u0000\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u0003\"\u000e\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0004*\b\u0012\u0004\u0012\u0002H\u00030\u00052\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u0002H\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00040\u0007H\u0086\b\u001a_\u0010\u0000\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u0003\"\u000e\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0004*\b\u0012\u0004\u0012\u0002H\u00030\u00052\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u0002H\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00040\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\t0\u0007H\u0086\b\u001aW\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0003\"\u000e\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0004*\b\u0012\u0004\u0012\u0002H\u00030\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000b2\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u0002H\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00040\u0007H\u0086\b\u001ak\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0003\"\u000e\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0004*\b\u0012\u0004\u0012\u0002H\u00030\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000b2\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u0002H\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00040\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\t0\u0007H\u0086\b\u00a8\u0006\f"}, d2={"average", "Ltec/uom/se/ComparableQuantity;", "Q", "E", "Ljavax/measure/Quantity;", "", "getValue", "Lkotlin/Function1;", "condition", "", "unit", "Ljavax/measure/Unit;", "core"})
public final class CollectionsKt {
    @Nullable
    public static final <E, Q extends Quantity<Q>> ComparableQuantity<Q> average(@NotNull Collection<? extends E> $receiver, @NotNull Function1<? super E, ? extends Quantity<Q>> getValue) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(getValue, (String)"getValue");
        ComparableQuantity totalValue = null;
        for (E element : $receiver) {
            if (totalValue == null) {
                totalValue = TypeKt.asComparable((Quantity)getValue.invoke(element));
                continue;
            }
            totalValue = OperatorsKt.plus(totalValue, (Quantity)getValue.invoke(element));
        }
        ComparableQuantity comparableQuantity = totalValue;
        return comparableQuantity != null ? comparableQuantity.divide((Number)$receiver.size()) : null;
    }

    @Nullable
    public static final <E, Q extends Quantity<Q>> ComparableQuantity<Q> average(@NotNull Collection<? extends E> $receiver, @NotNull Function1<? super E, ? extends Quantity<Q>> getValue, @NotNull Function1<? super E, Boolean> condition) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(getValue, (String)"getValue");
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        ComparableQuantity totalValue = null;
        int totalElements = 0;
        for (E element : $receiver) {
            if (!((Boolean)condition.invoke(element)).booleanValue()) continue;
            totalValue = totalValue == null ? TypeKt.asComparable((Quantity)getValue.invoke(element)) : OperatorsKt.plus(totalValue, (Quantity)getValue.invoke(element));
            ++totalElements;
        }
        ComparableQuantity comparableQuantity = totalValue;
        return comparableQuantity != null ? comparableQuantity.divide((Number)totalElements) : null;
    }

    @NotNull
    public static final <E, Q extends Quantity<Q>> ComparableQuantity<Q> average(@NotNull Collection<? extends E> $receiver, @NotNull Unit<Q> unit, @NotNull Function1<? super E, ? extends Quantity<Q>> getValue) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(unit, (String)"unit");
        Intrinsics.checkParameterIsNotNull(getValue, (String)"getValue");
        ComparableQuantity<Q> totalValue = OperatorsKt.invoke(0, unit);
        for (E element : $receiver) {
            totalValue = OperatorsKt.plus(totalValue, (Quantity)getValue.invoke(element));
        }
        return OperatorsKt.div(totalValue, (Number)$receiver.size());
    }

    @NotNull
    public static final <E, Q extends Quantity<Q>> ComparableQuantity<Q> average(@NotNull Collection<? extends E> $receiver, @NotNull Unit<Q> unit, @NotNull Function1<? super E, ? extends Quantity<Q>> getValue, @NotNull Function1<? super E, Boolean> condition) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(unit, (String)"unit");
        Intrinsics.checkParameterIsNotNull(getValue, (String)"getValue");
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        ComparableQuantity<Q> totalValue = OperatorsKt.invoke(0, unit);
        int totalElements = 0;
        for (E element : $receiver) {
            if (!((Boolean)condition.invoke(element)).booleanValue()) continue;
            totalValue = OperatorsKt.plus(totalValue, (Quantity)getValue.invoke(element));
            ++totalElements;
        }
        return OperatorsKt.div(totalValue, (Number)totalElements);
    }
}

