/*
 * Decompiled with CFR 0.152.
 */
package org.tenkiv.physikal.core;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.tenkiv.physikal.core.CoreUnitsKt;
import org.tenkiv.physikal.core.MetricPrefixesKt;
import org.tenkiv.physikal.core.OperatorsKt;
import tec.units.indriya.ComparableQuantity;
import tec.units.indriya.unit.MetricPrefix;
import tec.units.indriya.unit.Units;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a\u0010\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005*\u00020\u0001\u00a8\u0006\u0006"}, d2={"toDuration", "Ljava/time/Duration;", "Ljavax/measure/Quantity;", "Ljavax/measure/quantity/Time;", "toQuantity", "Ltec/units/indriya/ComparableQuantity;", "core"})
public final class TimeKt {
    @NotNull
    public static final Duration toDuration(@NotNull Quantity<Time> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Unit unit = Units.SECOND;
        Intrinsics.checkExpressionValueIsNotNull((Object)unit, (String)"SECOND");
        long secondsLong = OperatorsKt.toLongIn($receiver, unit);
        Quantity<Time> quantity = OperatorsKt.minus($receiver, (Quantity)CoreUnitsKt.getSecond(secondsLong));
        Unit unit2 = MetricPrefix.NANO((Unit)Units.SECOND);
        Intrinsics.checkExpressionValueIsNotNull((Object)unit2, (String)"NANO(SECOND)");
        long nanosLong = OperatorsKt.toLongIn(quantity, unit2);
        Duration duration = Duration.ofSeconds(secondsLong, nanosLong);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(secondsLong, nanosLong)");
        return duration;
    }

    @NotNull
    public static final ComparableQuantity<Time> toQuantity(@NotNull Duration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return OperatorsKt.plus(CoreUnitsKt.getSecond($receiver.get(ChronoUnit.SECONDS)), (Quantity)CoreUnitsKt.getSecond(MetricPrefixesKt.getNano($receiver.get(ChronoUnit.NANOS))));
    }
}

