/*
 * Decompiled with CFR 0.152.
 */
package org.tenkiv.physikal.si;

import javax.measure.Unit;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Length;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Time;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.tenkiv.physikal.core.MetricPrefixedNumber;
import org.tenkiv.physikal.core.OperatorsKt;
import si.uom.NonSI;
import si.uom.quantity.IonizingRadiation;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\"\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0005\"\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007\"\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005\"\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\"\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0005\"\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0005\"\u001b\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0005\"\u001b\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007\"\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0005\"\u001b\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0005\"\u001b\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0007\"\u001b\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0005\"\u001b\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007\"\u001b\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0005\"\u001b\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0007\"\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0005\"\u001b\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0005\"\u001b\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0005\u00a8\u0006'"}, d2={"angstrom", "Ltec/uom/se/ComparableQuantity;", "Ljavax/measure/quantity/Length;", "", "getAngstrom", "(Ljava/lang/Number;)Ltec/uom/se/ComparableQuantity;", "Lorg/tenkiv/physikal/core/MetricPrefixedNumber;", "(Lorg/tenkiv/physikal/core/MetricPrefixedNumber;)Ltec/uom/se/ComparableQuantity;", "atom", "Ljavax/measure/quantity/AmountOfSubstance;", "getAtom", "bar", "Ljavax/measure/quantity/Pressure;", "getBar", "daySideral", "Ljavax/measure/quantity/Time;", "getDaySideral", "inchOfMercury", "getInchOfMercury", "millimetreOfMercury", "getMillimetreOfMercury", "pi", "Ljavax/measure/quantity/Dimensionless;", "getPi", "rad", "Ljavax/measure/quantity/RadiationDoseAbsorbed;", "getRad", "rem", "Ljavax/measure/quantity/RadiationDoseEffective;", "getRem", "roentgen", "Lsi/uom/quantity/IonizingRadiation;", "getRoentgen", "yearCalendar", "getYearCalendar", "yearJulien", "getYearJulien", "yearSidereal", "getYearSidereal", "si-units"})
public final class Non_SiUnitsKt {
    @NotNull
    public static final ComparableQuantity<Dimensionless> getPi(@NotNull Number $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ComparableQuantity comparableQuantity = Quantities.getQuantity((Number)$receiver, (Unit)NonSI.PI);
        Intrinsics.checkExpressionValueIsNotNull((Object)comparableQuantity, (String)"Quantities.getQuantity<Dimensionless>(this, PI)");
        return comparableQuantity;
    }

    @NotNull
    public static final ComparableQuantity<AmountOfSubstance> getAtom(@NotNull Number $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ComparableQuantity comparableQuantity = Quantities.getQuantity((Number)$receiver, (Unit)NonSI.ATOM);
        Intrinsics.checkExpressionValueIsNotNull((Object)comparableQuantity, (String)"Quantities.getQuantity<A\u2026tOfSubstance>(this, ATOM)");
        return comparableQuantity;
    }

    @NotNull
    public static final ComparableQuantity<AmountOfSubstance> getAtom(@NotNull MetricPrefixedNumber $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Number number = $receiver.getNumber();
        Unit unit = NonSI.ATOM.transform($receiver.getPrefix().getConverter());
        Intrinsics.checkExpressionValueIsNotNull((Object)unit, (String)"ATOM.transform(prefix.converter)");
        return OperatorsKt.invoke((Number)number, (Unit)unit);
    }

    @NotNull
    public static final ComparableQuantity<Length> getAngstrom(@NotNull Number $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ComparableQuantity comparableQuantity = Quantities.getQuantity((Number)$receiver, (Unit)NonSI.ANGSTROM);
        Intrinsics.checkExpressionValueIsNotNull((Object)comparableQuantity, (String)"Quantities.getQuantity<Length>(this, ANGSTROM)");
        return comparableQuantity;
    }

    @NotNull
    public static final ComparableQuantity<Length> getAngstrom(@NotNull MetricPrefixedNumber $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Number number = $receiver.getNumber();
        Unit unit = NonSI.ANGSTROM.transform($receiver.getPrefix().getConverter());
        Intrinsics.checkExpressionValueIsNotNull((Object)unit, (String)"ANGSTROM.transform(prefix.converter)");
        return OperatorsKt.invoke((Number)number, (Unit)unit);
    }

    @NotNull
    public static final ComparableQuantity<Time> getDaySideral(@NotNull Number $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ComparableQuantity comparableQuantity = Quantities.getQuantity((Number)$receiver, (Unit)NonSI.DAY_SIDEREAL);
        Intrinsics.checkExpressionValueIsNotNull((Object)comparableQuantity, (String)"Quantities.getQuantity<Time>(this, DAY_SIDEREAL)");
        return comparableQuantity;
    }

    @NotNull
    public static final ComparableQuantity<Time> getYearCalendar(@NotNull Number $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ComparableQuantity comparableQuantity = Quantities.getQuantity((Number)$receiver, (Unit)NonSI.YEAR_CALENDAR);
        Intrinsics.checkExpressionValueIsNotNull((Object)comparableQuantity, (String)"Quantities.getQuantity<Time>(this, YEAR_CALENDAR)");
        return comparableQuantity;
    }

    @NotNull
    public static final ComparableQuantity<Time> getYearSidereal(@NotNull Number $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ComparableQuantity comparableQuantity = Quantities.getQuantity((Number)$receiver, (Unit)NonSI.YEAR_SIDEREAL);
        Intrinsics.checkExpressionValueIsNotNull((Object)comparableQuantity, (String)"Quantities.getQuantity<Time>(this, YEAR_SIDEREAL)");
        return comparableQuantity;
    }

    @NotNull
    public static final ComparableQuantity<Time> getYearJulien(@NotNull Number $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ComparableQuantity comparableQuantity = Quantities.getQuantity((Number)$receiver, (Unit)NonSI.YEAR_JULIEN);
        Intrinsics.checkExpressionValueIsNotNull((Object)comparableQuantity, (String)"Quantities.getQuantity<Time>(this, YEAR_JULIEN)");
        return comparableQuantity;
    }

    @NotNull
    public static final ComparableQuantity<Pressure> getBar(@NotNull Number $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ComparableQuantity comparableQuantity = Quantities.getQuantity((Number)$receiver, (Unit)NonSI.BAR);
        Intrinsics.checkExpressionValueIsNotNull((Object)comparableQuantity, (String)"Quantities.getQuantity<Pressure>(this, BAR)");
        return comparableQuantity;
    }

    @NotNull
    public static final ComparableQuantity<Pressure> getBar(@NotNull MetricPrefixedNumber $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Number number = $receiver.getNumber();
        Unit unit = NonSI.BAR.transform($receiver.getPrefix().getConverter());
        Intrinsics.checkExpressionValueIsNotNull((Object)unit, (String)"BAR.transform(prefix.converter)");
        return OperatorsKt.invoke((Number)number, (Unit)unit);
    }

    @NotNull
    public static final ComparableQuantity<Pressure> getMillimetreOfMercury(@NotNull Number $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ComparableQuantity comparableQuantity = Quantities.getQuantity((Number)$receiver, (Unit)NonSI.MILLIMETRE_OF_MERCURY);
        Intrinsics.checkExpressionValueIsNotNull((Object)comparableQuantity, (String)"Quantities.getQuantity<P\u2026s, MILLIMETRE_OF_MERCURY)");
        return comparableQuantity;
    }

    @NotNull
    public static final ComparableQuantity<Pressure> getMillimetreOfMercury(@NotNull MetricPrefixedNumber $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Number number = $receiver.getNumber();
        Unit unit = NonSI.MILLIMETRE_OF_MERCURY.transform($receiver.getPrefix().getConverter());
        Intrinsics.checkExpressionValueIsNotNull((Object)unit, (String)"MILLIMETRE_OF_MERCURY.transform(prefix.converter)");
        return OperatorsKt.invoke((Number)number, (Unit)unit);
    }

    @NotNull
    public static final ComparableQuantity<Pressure> getInchOfMercury(@NotNull Number $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ComparableQuantity comparableQuantity = Quantities.getQuantity((Number)$receiver, (Unit)NonSI.INCH_OF_MERCURY);
        Intrinsics.checkExpressionValueIsNotNull((Object)comparableQuantity, (String)"Quantities.getQuantity<P\u2026e>(this, INCH_OF_MERCURY)");
        return comparableQuantity;
    }

    @NotNull
    public static final ComparableQuantity<RadiationDoseAbsorbed> getRad(@NotNull Number $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ComparableQuantity comparableQuantity = Quantities.getQuantity((Number)$receiver, (Unit)NonSI.RAD);
        Intrinsics.checkExpressionValueIsNotNull((Object)comparableQuantity, (String)"Quantities.getQuantity<R\u2026nDoseAbsorbed>(this, RAD)");
        return comparableQuantity;
    }

    @NotNull
    public static final ComparableQuantity<RadiationDoseAbsorbed> getRad(@NotNull MetricPrefixedNumber $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Number number = $receiver.getNumber();
        Unit unit = NonSI.RAD.transform($receiver.getPrefix().getConverter());
        Intrinsics.checkExpressionValueIsNotNull((Object)unit, (String)"RAD.transform(prefix.converter)");
        return OperatorsKt.invoke((Number)number, (Unit)unit);
    }

    @NotNull
    public static final ComparableQuantity<RadiationDoseEffective> getRem(@NotNull Number $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ComparableQuantity comparableQuantity = Quantities.getQuantity((Number)$receiver, (Unit)NonSI.REM);
        Intrinsics.checkExpressionValueIsNotNull((Object)comparableQuantity, (String)"Quantities.getQuantity<R\u2026DoseEffective>(this, REM)");
        return comparableQuantity;
    }

    @NotNull
    public static final ComparableQuantity<RadiationDoseEffective> getRem(@NotNull MetricPrefixedNumber $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Number number = $receiver.getNumber();
        Unit unit = NonSI.REM.transform($receiver.getPrefix().getConverter());
        Intrinsics.checkExpressionValueIsNotNull((Object)unit, (String)"REM.transform(prefix.converter)");
        return OperatorsKt.invoke((Number)number, (Unit)unit);
    }

    @NotNull
    public static final ComparableQuantity<IonizingRadiation> getRoentgen(@NotNull Number $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ComparableQuantity comparableQuantity = Quantities.getQuantity((Number)$receiver, (Unit)NonSI.ROENTGEN);
        Intrinsics.checkExpressionValueIsNotNull((Object)comparableQuantity, (String)"Quantities.getQuantity<I\u2026adiation>(this, ROENTGEN)");
        return comparableQuantity;
    }

    @NotNull
    public static final ComparableQuantity<IonizingRadiation> getRoentgen(@NotNull MetricPrefixedNumber $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Number number = $receiver.getNumber();
        Unit unit = NonSI.ROENTGEN.transform($receiver.getPrefix().getConverter());
        Intrinsics.checkExpressionValueIsNotNull((Object)unit, (String)"ROENTGEN.transform(prefix.converter)");
        return OperatorsKt.invoke((Number)number, (Unit)unit);
    }
}

