/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.check;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.tentackle.common.BundleFactory;
import org.tentackle.maven.AbstractTentackleAnnotationProcessingMojo;
import org.tentackle.script.ScriptFactory;

public class AbstractCheckMojo
extends AbstractTentackleAnnotationProcessingMojo {
    @Parameter(defaultValue="${project.build.sourceDirectory}", property="tentackle.sourceDir", required=true)
    protected File sourceDir;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    protected List<String> classpathElements;
    @Parameter
    protected String locales;
    @Parameter(defaultValue="${skipTests}")
    protected boolean skipTests;
    @Parameter
    protected String scriptingLanguage;
    protected List<Locale> bundleLocales;

    public void prepareExecute() throws MojoFailureException {
        if (!this.skipTests) {
            this.setMojoParameters(this.sourceDir, this.classpathElements);
            this.bundleLocales = new ArrayList<Locale>();
            if (this.locales != null) {
                StringTokenizer stok = new StringTokenizer(this.locales, ",; \n\r\t");
                while (stok.hasMoreTokens()) {
                    String localeName = stok.nextToken().replace('_', '-');
                    Locale bundleLocale = Locale.forLanguageTag(localeName);
                    if (bundleLocale != null && !bundleLocale.toString().isEmpty()) {
                        this.bundleLocales.add(bundleLocale);
                        continue;
                    }
                    this.getLog().warn((CharSequence)("no such locale: " + localeName));
                }
            }
            if (this.bundleLocales.isEmpty()) {
                Locale bundleLocale = Locale.getDefault();
                this.getLog().warn((CharSequence)("fallback to default locale " + bundleLocale));
                this.bundleLocales.add(bundleLocale);
            }
            BundleFactory.getInstance().setClassLoader(this.getProcessingClassloader());
            if (this.scriptingLanguage != null) {
                ScriptFactory.getInstance().setDefaultLanguage(this.scriptingLanguage);
            }
        }
    }

    protected boolean validate() throws MojoExecutionException {
        if (this.skipTests) {
            this.getLog().info((CharSequence)"tests are skipped");
            return false;
        }
        return super.validate();
    }
}

