/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.check;

import java.io.File;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.tentackle.buildsupport.AbstractTentackleProcessor;
import org.tentackle.common.ExceptionHelper;
import org.tentackle.common.LocaleProvider;
import org.tentackle.maven.plugin.check.AbstractCheckMojo;
import org.tentackle.maven.plugin.check.CheckValidationsProcessor;
import org.tentackle.misc.CompoundValue;
import org.tentackle.script.Script;
import org.tentackle.script.ScriptVariable;
import org.tentackle.validate.ValidationRuntimeException;
import org.tentackle.validate.ValidationUtilities;
import org.tentackle.validate.Validator;
import org.tentackle.validate.ValidatorCompoundValueFactory;

@Mojo(name="validations", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class CheckValidationsMojo
extends AbstractCheckMojo {
    private final CheckValidationsProcessor processor = new CheckValidationsProcessor();
    private int errors;
    private int scriptCount;

    public CheckValidationsMojo() {
        this.addProcessor(this.processor);
    }

    protected void initializeProcessor(AbstractTentackleProcessor processor, File srcDir) throws MojoFailureException {
        super.initializeProcessor(processor, srcDir);
        ((CheckValidationsProcessor)processor).setProcessingClassLoader(this.getProcessingClassloader());
    }

    public void finishExecute() throws MojoExecutionException, MojoFailureException {
        ValidationUtilities.getInstance().setValidationBundleClassLoader(this.getProcessingClassloader());
        int count = this.processor.getValidators().size();
        this.errors = this.processor.getErrors();
        for (Object bundleLocale : this.bundleLocales) {
            LocaleProvider.getInstance().setCurrentLocale((Locale)bundleLocale);
            for (CheckValidationsProcessor.ValidatorEntry validatorEntry : this.processor.getValidators()) {
                this.checkValue(validatorEntry);
                this.checkMessage(validatorEntry);
                this.checkCondition(validatorEntry);
            }
        }
        StringBuilder localestr = new StringBuilder();
        for (Locale bundleLocale : this.bundleLocales) {
            if (localestr.length() > 0) {
                localestr.append(", ");
            }
            localestr.append(bundleLocale);
        }
        String msg = count + " annotation" + (count == 1 ? "" : "s") + ", " + this.scriptCount + " script" + (this.scriptCount == 1 ? "" : "s") + " checked for " + localestr + ", ";
        if (this.errors > 0) {
            msg = msg + this.errors + " errors";
            this.getLog().error((CharSequence)msg);
            throw new MojoExecutionException(msg);
        }
        this.getLog().info((CharSequence)(msg + "no errors"));
    }

    private void checkMessage(CheckValidationsProcessor.ValidatorEntry validatorEntry) throws MojoFailureException {
        try {
            CompoundValue cv;
            Script script;
            Validator validator = validatorEntry.validator();
            Class<?> enclosingClass = this.getProcessingClassloader().loadClass(validatorEntry.className());
            String message = validator.getMessage();
            if (message != null && !message.isEmpty() && (script = (cv = ValidatorCompoundValueFactory.getInstance().createMessageParameter(message)).getScript()) != null) {
                ++this.scriptCount;
                cv.getValue(enclosingClass, new ScriptVariable[0]);
            }
        }
        catch (ClassNotFoundException | RuntimeException ex) {
            ValidationRuntimeException vx;
            ++this.errors;
            MissingResourceException mx = (MissingResourceException)ExceptionHelper.extractException(MissingResourceException.class, (boolean)true, (Throwable)ex);
            if (mx != null && (vx = (ValidationRuntimeException)ExceptionHelper.extractException(ValidationRuntimeException.class, (boolean)true, (Throwable)ex)) != null) {
                this.getLog().error((CharSequence)(vx.getMessage() + " for " + validatorEntry));
                return;
            }
            this.getLog().error((CharSequence)("validation message check failed for validator " + validatorEntry), (Throwable)ex);
        }
    }

    private void checkCondition(CheckValidationsProcessor.ValidatorEntry validatorEntry) {
        try {
            CompoundValue cv;
            Script script;
            Validator validator = validatorEntry.validator();
            String condition = validator.getCondition();
            if (condition != null && !condition.isEmpty() && (script = (cv = ValidatorCompoundValueFactory.getInstance().createConditionParameter(condition)).getScript()) != null) {
                ++this.scriptCount;
                script.validate();
            }
        }
        catch (RuntimeException ex) {
            this.getLog().error((CharSequence)("validation condition check failed for validator " + validatorEntry), (Throwable)ex);
            ++this.errors;
        }
    }

    private void checkValue(CheckValidationsProcessor.ValidatorEntry validatorEntry) {
        try {
            CompoundValue cv;
            Script script;
            Validator validator = validatorEntry.validator();
            String value = validator.getValue();
            if (value != null && !value.isEmpty() && (script = (cv = ValidatorCompoundValueFactory.getInstance().createValueParameter(value, Object.class)).getScript()) != null) {
                ++this.scriptCount;
                script.validate();
            }
        }
        catch (RuntimeException ex) {
            this.getLog().error((CharSequence)("validation value check failed for validator " + validatorEntry), (Throwable)ex);
            ++this.errors;
        }
    }
}

