/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.check;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.tentackle.common.BundleSupport;
import org.tentackle.maven.check.AbstractCheckMojo;
import org.tentackle.maven.check.BundleKey;
import org.tentackle.maven.check.CheckBundlesProcessor;
import org.tentackle.maven.check.CheckBundlesScanner;

@Mojo(name="bundles", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class CheckBundlesMojo
extends AbstractCheckMojo {
    private final CheckBundlesScanner bundleScanner = new CheckBundlesScanner();

    public CheckBundlesMojo() {
        this.addProcessor(new CheckBundlesProcessor(this.bundleScanner));
    }

    /*
     * WARNING - void declaration
     */
    public void finishExecute() throws MojoExecutionException {
        void var3_7;
        HashSet<String> usedBundleNames = new HashSet<String>();
        for (BundleKey bundleKey : this.bundleScanner.getBundleKeys()) {
            String bundleName = bundleKey.getBundleName();
            if (!usedBundleNames.add(bundleName) || !this.verbosityLevel.isDebug()) continue;
            this.getLog().info((CharSequence)("bundle " + bundleName + " is referenced"));
        }
        HashMap<NameKey, ResourceBundle> bundleMap = new HashMap<NameKey, ResourceBundle>();
        for (BundleSupport bundleSupport : BundleSupport.getBundles((ClassLoader)this.getProcessingClassloader())) {
            String bundleName = bundleSupport.getBundleName();
            if (!usedBundleNames.contains(bundleName)) continue;
            for (Locale bundleLocale : this.bundleLocales) {
                try {
                    ResourceBundle bundle = ResourceBundle.getBundle(bundleName, bundleLocale, this.getProcessingClassloader());
                    if (this.verbosityLevel.isDebug()) {
                        this.getLog().info((CharSequence)("loaded bundle " + bundleName + ", locale " + bundleLocale + ", annotated in class " + bundleSupport.getClassName()));
                    }
                    bundleMap.putIfAbsent(new NameKey(bundleLocale, bundleName), bundle);
                }
                catch (RuntimeException rex) {
                    this.getLog().error((CharSequence)("could not load bundle " + bundleName + ": " + rex.getMessage()));
                }
            }
        }
        boolean bl = false;
        int keyCount = 0;
        for (BundleKey bundleKey : this.bundleScanner.getBundleKeys()) {
            ++keyCount;
            String bundleName = bundleKey.getBundleName();
            for (Locale bundleLocale : this.bundleLocales) {
                void var3_6;
                ResourceBundle bundle = (ResourceBundle)bundleMap.get(new NameKey(bundleLocale, bundleName));
                if (bundle == null) {
                    this.getLog().error((CharSequence)("bundle " + bundleName + " not registered by annotation"));
                    ++var3_6;
                    continue;
                }
                try {
                    bundle.getString(bundleKey.getKey());
                }
                catch (MissingResourceException mx) {
                    this.getLog().error((CharSequence)("missing resource " + bundleKey + " for " + bundleLocale));
                    ++var3_6;
                }
            }
        }
        for (String string : usedBundleNames) {
            Set<String> keys = null;
            for (Locale bundleLocale : this.bundleLocales) {
                NameKey nameKey = new NameKey(bundleLocale, string);
                ResourceBundle bundle = (ResourceBundle)bundleMap.get(nameKey);
                if (bundle == null) {
                    this.getLog().error((CharSequence)("no bundle " + string + " for " + bundleLocale));
                    ++var3_7;
                    continue;
                }
                if (keys == null) {
                    keys = bundle.keySet();
                    continue;
                }
                Set<String> bundleKeys = bundle.keySet();
                for (String key : keys) {
                    if (bundleKeys.contains(key)) continue;
                    this.getLog().error((CharSequence)("key '" + key + "' missing in " + nameKey));
                    ++var3_7;
                }
                for (String key : bundle.keySet()) {
                    if (keys.contains(key)) continue;
                    this.getLog().error((CharSequence)("key '" + key + "' for " + bundleLocale + " not defined in all locales of " + string));
                    ++var3_7;
                }
            }
        }
        StringBuilder localestr = new StringBuilder();
        for (Locale bundleLocale : this.bundleLocales) {
            if (localestr.length() > 0) {
                localestr.append(", ");
            }
            localestr.append(bundleLocale);
        }
        String string = keyCount + " key" + (keyCount == 1 ? "" : "s") + " checked for " + localestr + " in " + usedBundleNames.size() + " bundle" + (usedBundleNames.size() == 1 ? "" : "s") + ", ";
        if (var3_7 > 0) {
            String string2 = string + (int)var3_7 + " errors";
            this.getLog().error((CharSequence)string2);
            throw new MojoExecutionException(string2);
        }
        this.getLog().info((CharSequence)(string + "no errors"));
    }

    private static class NameKey {
        private final Locale locale;
        private final String name;

        private NameKey(Locale locale, String name) {
            this.locale = locale;
            this.name = name;
        }

        public String toString() {
            return this.name + "(" + this.locale + ")";
        }

        public int hashCode() {
            int hash = 5;
            hash = 59 * hash + Objects.hashCode(this.locale);
            hash = 59 * hash + Objects.hashCode(this.name);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NameKey other = (NameKey)obj;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            return Objects.equals(this.locale, other.locale);
        }
    }
}

