/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.check;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Name;
import org.tentackle.maven.check.BundleKey;

public class CheckBundlesScanner
extends TreePathScanner<Object, Trees> {
    private final List<BundleKey> bundleKeys = new ArrayList<BundleKey>();

    @Override
    public Object visitMethodInvocation(MethodInvocationTree mit, Trees trees) {
        ExpressionTree stringExpr;
        String key;
        List<? extends ExpressionTree> methodArgs;
        MemberSelectTree fieldAccess;
        Name methodName;
        ExpressionTree methodSelect = mit.getMethodSelect();
        if (methodSelect.getKind() == Tree.Kind.MEMBER_SELECT && "getString".equals((methodName = (fieldAccess = (MemberSelectTree)methodSelect).getIdentifier()).toString()) && (methodArgs = mit.getArguments()).size() == 1 && (key = this.determineBundleKey(stringExpr = methodArgs.get(0))) != null) {
            ExpressionTree classExpr = fieldAccess.getExpression();
            String className = classExpr.toString();
            TreePath currentPath = this.getCurrentPath();
            CompilationUnitTree compilationUnitTree = currentPath.getCompilationUnit();
            ExpressionTree packageTree = compilationUnitTree.getPackageName();
            String packageName = packageTree.toString();
            Object bundleName = null;
            String lastName = "." + className;
            for (ImportTree importTree : compilationUnitTree.getImports()) {
                Tree ident = importTree.getQualifiedIdentifier();
                String identName = ident.toString();
                if (!identName.endsWith(lastName)) continue;
                bundleName = identName;
                break;
            }
            if (bundleName == null) {
                bundleName = packageName + lastName;
            }
            String usingClassName = this.buildUsingClassName(currentPath);
            this.bundleKeys.add(new BundleKey(usingClassName, (String)bundleName, key));
        }
        return super.visitMethodInvocation(mit, trees);
    }

    public List<BundleKey> getBundleKeys() {
        return this.bundleKeys;
    }

    private String determineBundleKey(ExpressionTree stringExpr) {
        LiteralTree stringLit;
        Object literal;
        String key = null;
        if (stringExpr.getKind() == Tree.Kind.STRING_LITERAL && (literal = (stringLit = (LiteralTree)stringExpr).getValue()) instanceof String) {
            key = (String)literal;
        }
        return key;
    }

    private String buildUsingClassName(TreePath path) {
        StringBuilder name = new StringBuilder();
        for (Tree tree : path) {
            if (tree.getKind() == Tree.Kind.CLASS) {
                String simpleName = ((ClassTree)tree).getSimpleName().toString();
                if (name.length() == 0) {
                    name.append(simpleName);
                    continue;
                }
                name.insert(0, ".");
                name.insert(0, simpleName);
                continue;
            }
            if (tree.getKind() != Tree.Kind.COMPILATION_UNIT) continue;
            name.insert(0, ((CompilationUnitTree)tree).getPackageName().toString() + ".");
        }
        if (name.toString().endsWith(".")) {
            name = new StringBuilder(name.substring(0, name.length() - 1));
        }
        return name.toString();
    }
}

