/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.check;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.tentackle.buildsupport.AbstractTentackleProcessor;
import org.tentackle.common.ExceptionHelper;
import org.tentackle.common.LocaleProvider;
import org.tentackle.common.ServiceFactory;
import org.tentackle.common.StringHelper;
import org.tentackle.maven.check.AbstractCheckMojo;
import org.tentackle.maven.check.CheckValidationsProcessor;
import org.tentackle.misc.CompoundValue;
import org.tentackle.script.Script;
import org.tentackle.script.ScriptConverter;
import org.tentackle.script.ScriptVariable;
import org.tentackle.validate.ValidationRuntimeException;
import org.tentackle.validate.ValidationUtilities;
import org.tentackle.validate.Validator;
import org.tentackle.validate.validator.MessageScriptConverter;
import org.tentackle.validate.validator.ValidationScriptConverter;

@Mojo(name="validations", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class CheckValidationsMojo
extends AbstractCheckMojo {
    private final CheckValidationsProcessor processor = new CheckValidationsProcessor();
    private final Map<String, ScriptConverter> messageConverterMap;
    private final Map<String, ScriptConverter> validationConverterMap;
    private int errors;
    private int scriptCount;

    public CheckValidationsMojo() {
        this.addProcessor(this.processor);
        this.messageConverterMap = new HashMap<String, ScriptConverter>();
        this.validationConverterMap = new HashMap<String, ScriptConverter>();
    }

    protected void initializeProcessor(AbstractTentackleProcessor processor, File srcDir) throws MojoFailureException {
        super.initializeProcessor(processor, srcDir);
        ((CheckValidationsProcessor)processor).setProcessingClassLoader(this.getProcessingClassloader());
    }

    public void finishExecute() throws MojoExecutionException, MojoFailureException {
        ScriptConverter converter;
        String language;
        ValidationUtilities.getInstance().setValidationBundleClassLoader(this.getProcessingClassloader());
        int count = this.processor.getValidators().size();
        this.errors = this.processor.getErrors();
        for (Map.Entry entry : ServiceFactory.getServiceFinder().createNameMap(MessageScriptConverter.class.getName()).entrySet()) {
            try {
                language = StringHelper.stripEnclosingDoubleQuotes((String)((String)entry.getKey()));
                converter = (ScriptConverter)Class.forName((String)entry.getValue()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.messageConverterMap.put(language, converter);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new MojoFailureException("message script converter configuration failed", (Throwable)ex);
            }
        }
        for (Map.Entry entry : ServiceFactory.getServiceFinder().createNameMap(ValidationScriptConverter.class.getName()).entrySet()) {
            try {
                language = StringHelper.stripEnclosingDoubleQuotes((String)((String)entry.getKey()));
                converter = (ScriptConverter)Class.forName((String)entry.getValue()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.validationConverterMap.put(language, converter);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new MojoFailureException("validation script converter configuration failed", (Throwable)ex);
            }
        }
        for (Object bundleLocale : this.bundleLocales) {
            LocaleProvider.getInstance().setCurrentLocale((Locale)bundleLocale);
            for (CheckValidationsProcessor.ValidatorEntry validatorEntry : this.processor.getValidators()) {
                this.checkMessage(validatorEntry);
                this.checkCondition(validatorEntry);
            }
        }
        StringBuilder localestr = new StringBuilder();
        for (Locale bundleLocale : this.bundleLocales) {
            if (localestr.length() > 0) {
                localestr.append(", ");
            }
            localestr.append(bundleLocale);
        }
        String msg = count + " annotation" + (count == 1 ? "" : "s") + ", " + this.scriptCount + " script" + (this.scriptCount == 1 ? "" : "s") + " checked for " + localestr + ", ";
        if (this.errors > 0) {
            msg = msg + this.errors + " errors";
            this.getLog().error((CharSequence)msg);
            throw new MojoExecutionException(msg);
        }
        this.getLog().info((CharSequence)(msg + "no errors"));
    }

    private void checkMessage(CheckValidationsProcessor.ValidatorEntry validatorEntry) throws MojoFailureException {
        try {
            Script script;
            CompoundValue cv;
            Validator validator = validatorEntry.getValidator();
            Class<?> enclosingClass = this.getProcessingClassloader().loadClass(validatorEntry.getClassName());
            String message = validator.getMessage();
            if (message != null && !message.isEmpty() && (cv = new CompoundValue(message, String.class)).getType() == CompoundValue.Type.SCRIPT && (script = cv.getScript()) != null) {
                ++this.scriptCount;
                if (message.contains("@(")) {
                    ScriptConverter converter = this.messageConverterMap.get(script.getLanguage().getName());
                    if (converter == null) {
                        throw new MojoFailureException("missing message script converter for " + script.getLanguage());
                    }
                    script.setConverter(converter);
                    cv.getValue(enclosingClass, new ScriptVariable[0]);
                } else {
                    script.parse();
                }
            }
        }
        catch (ClassNotFoundException | RuntimeException ex) {
            ValidationRuntimeException vx;
            ++this.errors;
            MissingResourceException mx = (MissingResourceException)ExceptionHelper.extractException(MissingResourceException.class, (boolean)true, (Throwable)ex);
            if (mx != null && (vx = (ValidationRuntimeException)ExceptionHelper.extractException(ValidationRuntimeException.class, (boolean)true, (Throwable)ex)) != null) {
                this.getLog().error((CharSequence)(vx.getMessage() + " for " + validatorEntry));
                return;
            }
            this.getLog().error((CharSequence)("validation message check failed for validator " + validatorEntry), (Throwable)ex);
        }
    }

    private void checkCondition(CheckValidationsProcessor.ValidatorEntry validatorEntry) {
        try {
            Script script;
            CompoundValue cv;
            Validator validator = validatorEntry.getValidator();
            String condition = validator.getCondition();
            if (condition != null && !condition.isEmpty() && (cv = new CompoundValue(condition, Boolean.class)).getType() == CompoundValue.Type.SCRIPT && (script = cv.getScript()) != null) {
                script.setConverter(this.validationConverterMap.get(script.getLanguage().getName()));
                ++this.scriptCount;
                script.parse();
            }
        }
        catch (RuntimeException ex) {
            this.getLog().error((CharSequence)("validation condition check failed for validator " + validatorEntry), (Throwable)ex);
            ++this.errors;
        }
    }
}

