/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.check;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.tentackle.buildsupport.AbstractTentackleProcessor;
import org.tentackle.validate.Validation;
import org.tentackle.validate.Validator;

@SupportedOptions(value={"verbosity"})
@SupportedAnnotationTypes(value={"*"})
public class CheckValidationsProcessor
extends AbstractTentackleProcessor {
    private static final String VALIDATION_CLASSNAME = Validation.class.getName();
    private ClassLoader processingClassLoader;
    private int errors;
    private final List<ValidatorEntry> validators = new ArrayList<ValidatorEntry>();

    public int getErrors() {
        return this.errors;
    }

    public List<ValidatorEntry> getValidators() {
        return this.validators;
    }

    public ClassLoader getProcessingClassLoader() {
        return this.processingClassLoader == null ? ((Object)((Object)this)).getClass().getClassLoader() : this.processingClassLoader;
    }

    public void setProcessingClassLoader(ClassLoader processingClassLoader) {
        this.processingClassLoader = processingClassLoader;
    }

    public boolean process(Set<? extends TypeElement> annotationTypes, RoundEnvironment roundEnv) {
        boolean claimed = false;
        if (!roundEnv.processingOver()) {
            for (TypeElement typeElement : annotationTypes) {
                if (typeElement.toString().startsWith("java.lang.")) continue;
                for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
                    if (!annotationMirror.getAnnotationType().toString().equals(VALIDATION_CLASSNAME)) continue;
                    if (this.isDebugLogging()) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "processing annotation " + String.valueOf(typeElement));
                    }
                    this.processAnnotation(typeElement, annotationMirror, roundEnv);
                    claimed = true;
                }
            }
        }
        return claimed;
    }

    public void processAnnotation(TypeElement annotationType, AnnotationMirror mirror, RoundEnvironment roundEnv) {
        Class<?> annotationClass;
        try {
            annotationClass = this.processingClassLoader.loadClass(annotationType.toString());
        }
        catch (ClassNotFoundException nfe) {
            this.getProcessingEnvironment().getMessager().printMessage(Diagnostic.Kind.ERROR, "cannot load annotation class " + String.valueOf(annotationType) + ": " + String.valueOf(nfe));
            return;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
            if (this.isDebugLogging()) {
                this.getProcessingEnvironment().getMessager().printMessage(Diagnostic.Kind.NOTE, "found " + String.valueOf(element) + " in " + String.valueOf(element.getEnclosingElement()) + " annotated with " + annotationClass.getName());
            }
            for (Annotation annotation : element.getAnnotationsByType(annotationClass)) {
                Class<?> validatorClass = null;
                Map<? extends ExecutableElement, ? extends AnnotationValue> annotationParameters = mirror.getElementValues();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationParameters.entrySet()) {
                    AnnotationValue anno = entry.getValue();
                    String implName = anno.toString();
                    if (implName.endsWith(".class")) {
                        implName = implName.substring(0, implName.length() - 6);
                    }
                    try {
                        validatorClass = this.getProcessingClassLoader().loadClass(implName);
                        break;
                    }
                    catch (ClassNotFoundException nx) {
                        this.getProcessingEnvironment().getMessager().printMessage(Diagnostic.Kind.ERROR, "cannot load validator implementation class " + implName);
                        ++this.errors;
                    }
                }
                if (validatorClass == null) continue;
                try {
                    Element enclosingClass;
                    Validator validator = (Validator)validatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    validator.setAnnotation(annotation);
                    for (enclosingClass = element; enclosingClass != null && enclosingClass.getKind() != ElementKind.INTERFACE && enclosingClass.getKind() != ElementKind.CLASS; enclosingClass = enclosingClass.getEnclosingElement()) {
                    }
                    String enclosingName = enclosingClass == null ? "java.lang.Object" : enclosingClass.asType().toString();
                    int ndx = enclosingName.indexOf(60);
                    if (ndx > 0) {
                        enclosingName = enclosingName.substring(0, ndx);
                    }
                    this.validators.add(new ValidatorEntry(validator, enclosingName));
                }
                catch (ClassCastException cx) {
                    this.getProcessingEnvironment().getMessager().printMessage(Diagnostic.Kind.ERROR, String.valueOf(validatorClass) + " is not a validator");
                    ++this.errors;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    this.getProcessingEnvironment().getMessager().printMessage(Diagnostic.Kind.ERROR, "cannot create validator for " + String.valueOf(validatorClass));
                    ++this.errors;
                }
            }
        }
    }

    public record ValidatorEntry(Validator validator, String className) {
        @Override
        public String toString() {
            return this.validator.getClass().getName() + " in " + this.className;
        }
    }
}

