/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class FileHelper {
    public static InputStream createInputStream(Class<?> caller, String name) throws IOException {
        InputStream is;
        if (caller == null) {
            caller = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
        }
        if ((is = caller.getResourceAsStream(name)) == null && (is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name)) == null) {
            Module module = caller.getClassLoader().getUnnamedModule();
            if (module != null) {
                is = module.getResourceAsStream(name);
            }
            if (is == null) {
                throw new FileNotFoundException("no such resource: " + name);
            }
        }
        is = new BufferedInputStream(is);
        return is;
    }

    public static Properties loadProperties(String name, boolean asResource) throws IOException {
        Properties dbProps = new Properties();
        if (name != null) {
            if (((String)name).indexOf(46) < 0) {
                name = (String)name + ".properties";
            }
            if (!((String)name).startsWith("/")) {
                name = "/" + (String)name;
            }
            try (InputStream is = asResource ? FileHelper.createInputStream(FileHelper.class, (String)name) : new FileInputStream((String)name);){
                dbProps.load(is);
            }
        }
        return dbProps;
    }

    public static Properties loadProperties(String name) throws IOException {
        try {
            return FileHelper.loadProperties(name, false);
        }
        catch (FileNotFoundException e1) {
            return FileHelper.loadProperties(name, true);
        }
    }

    private FileHelper() {
    }
}

