/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.tentackle.common.ModuleHook;
import org.tentackle.common.ModuleInfo;
import org.tentackle.common.TentackleRuntimeException;

public final class ModuleSorter {
    public static final ModuleSorter INSTANCE = new ModuleSorter();
    private final Map<String, ModuleInfo> nameToModules = new HashMap<String, ModuleInfo>();
    private final Map<String, ModuleInfo> urlToModules = new HashMap<String, ModuleInfo>();
    private final List<ModuleInfo> sortedModules;

    public ModuleSorter() {
        ServiceLoader.load(ModuleHook.class).stream().map(ServiceLoader.Provider::get).forEach(hook -> {
            ModuleInfo info = new ModuleInfo((ModuleHook)hook);
            this.nameToModules.put(info.getModule().getName(), info);
            this.urlToModules.put(info.getUrlPath(), info);
        });
        this.sortedModules = new ArrayList<ModuleInfo>();
        for (ModuleInfo info : this.nameToModules.values()) {
            if (info.getOrdinal() != 0) continue;
            this.visit(info, this.sortedModules);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (ModuleInfo info : this.sortedModules) {
            buf.append(info).append('\n');
        }
        return buf.toString();
    }

    public List<ModuleInfo> getModuleInfos() {
        return this.sortedModules;
    }

    public ModuleInfo getModuleInfo(String name) {
        return this.nameToModules.get(name);
    }

    public ModuleInfo getModuleInfo(URL url) {
        ModuleInfo info = null;
        String path = url.getPath();
        switch (url.getProtocol()) {
            case "jrt": {
                int ndx;
                String name = url.getPath();
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                if ((ndx = name.indexOf(47)) >= 0) {
                    name = name.substring(0, ndx);
                }
                info = this.nameToModules.get(name);
                break;
            }
            case "jar": {
                int lndx = path.lastIndexOf(33);
                if (lndx > 7) {
                    String urlPath = path.substring(7, lndx);
                    info = this.urlToModules.get(urlPath);
                    break;
                }
                throw new TentackleRuntimeException("malformed jar url: " + url);
            }
            case "file": {
                int fndx = path.indexOf("/META-INF/");
                if (fndx > 0) {
                    String urlPath = path.substring(0, fndx + 1);
                    info = this.urlToModules.get(urlPath);
                    break;
                }
                throw new TentackleRuntimeException("malformed file url: " + url);
            }
        }
        return info;
    }

    public Collection<URL> sort(Enumeration<URL> urls) {
        TreeSet<SortKey> urlSet = new TreeSet<SortKey>();
        ArrayList<URL> unsortedUrls = new ArrayList<URL>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            ModuleInfo info = this.getModuleInfo(url);
            if (info != null) {
                urlSet.add(new SortKey(info.getOrdinal(), url));
                continue;
            }
            unsortedUrls.add(url);
        }
        List<URL> sortedUrls = urlSet.stream().map(SortKey::getUrl).collect(Collectors.toList());
        sortedUrls.addAll(unsortedUrls);
        return sortedUrls;
    }

    private void visit(ModuleInfo info, List<ModuleInfo> sortedList) {
        if (info.getOrdinal() == 0) {
            if (info.isVisited()) {
                throw new TentackleRuntimeException("unsortable module hierarchy (cyclic dependency?)");
            }
            info.setVisited(true);
            Iterator<String> iter = info.getRequiredModuleNames().iterator();
            while (iter.hasNext()) {
                String name = iter.next();
                ModuleInfo subInfo = this.nameToModules.get(name);
                if (subInfo != null) {
                    this.visit(subInfo, sortedList);
                    continue;
                }
                iter.remove();
            }
            info.setOrdinal(sortedList.size() + 1);
            sortedList.add(info);
        }
    }

    private static class SortKey
    implements Comparable<SortKey> {
        final int ordinal;
        final String name;
        final URL url;

        public SortKey(int ordinal, URL url) {
            this.ordinal = ordinal;
            this.url = url;
            this.name = url.toExternalForm();
        }

        public URL getUrl() {
            return this.url;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + Objects.hashCode(this.url);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SortKey other = (SortKey)obj;
            return Objects.equals(this.url, other.url);
        }

        @Override
        public int compareTo(SortKey o) {
            int rv = o.ordinal - this.ordinal;
            if (rv == 0) {
                rv = this.name.compareTo(o.name);
            }
            return rv;
        }
    }
}

