/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tentackle.common.DefaultServiceFinder;
import org.tentackle.common.ServiceFinder;
import org.tentackle.common.ServiceFinderKey;
import org.tentackle.common.TentackleRuntimeException;

public class ServiceFactory {
    private static final Logger LOGGER = Logger.getLogger(ServiceFactory.class.getName());
    private static String factoryClassname;
    private static ClassLoader factoryClassloader;
    public static final ServiceFactory INSTANCE;
    private final Map<ClassLoaderKey, LinkedList<ClassLoader>> explicitLoaders;
    private Class<? extends ServiceFinder> serviceFinderClass;
    private final Map<ServiceFinderKey, ServiceFinder> finderMap;
    private ClassLoader fixedClassLoader;

    public static void setFactoryClassname(String factoryClassname) {
        ServiceFactory.factoryClassname = factoryClassname;
    }

    public static String getFactoryClassname() {
        return factoryClassname;
    }

    public static void setFactoryClassloader(ClassLoader factoryClassloader) {
        ServiceFactory.factoryClassloader = factoryClassloader;
    }

    public static ClassLoader getFactoryClassloader() {
        return factoryClassloader;
    }

    private static ServiceFactory createServiceFactory() {
        if (factoryClassname != null) {
            try {
                Class<?> clazz = factoryClassloader == null ? Class.forName(factoryClassname) : Class.forName(factoryClassname, true, factoryClassloader);
                return (ServiceFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                LOGGER.log(Level.WARNING, "creating instance of Constants.SERVICE_FACTORY_CLASSNAME failed -> trying ServiceLoader...", ex);
            }
        }
        try {
            ServiceLoader<ServiceFactory> loader = factoryClassloader == null ? ServiceLoader.load(ServiceFactory.class) : ServiceLoader.load(ServiceFactory.class, factoryClassloader);
            for (ServiceFactory factory : loader) {
                if (factory == null) continue;
                return factory;
            }
        }
        catch (ServiceConfigurationError cx) {
            LOGGER.log(Level.WARNING, "locating the service factory failed -> fallback to ServiceFactory", cx);
        }
        return new ServiceFactory();
    }

    public static ServiceFinder getServiceFinder(ClassLoader loader, String servicePath) {
        return INSTANCE.getServiceFinderImpl(loader, servicePath);
    }

    public static ServiceFinder getServiceFinder(String servicePath) {
        return INSTANCE.getServiceFinderImpl(servicePath);
    }

    public static ServiceFinder getServiceFinder() {
        return INSTANCE.getServiceFinderImpl();
    }

    public static <T> Class<T> createServiceClass(Class<T> serviceClass) {
        try {
            return INSTANCE.getServiceFinderImpl().findFirstServiceProvider(serviceClass);
        }
        catch (ClassNotFoundException ex) {
            throw new TentackleRuntimeException("cannot create service class for " + serviceClass, ex);
        }
    }

    public static <T> T createService(Class<T> serviceClass) {
        try {
            return ServiceFactory.createServiceClass(serviceClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new TentackleRuntimeException("cannot create instance for " + serviceClass, ex);
        }
    }

    public static <T> T createService(Class<T> serviceClass, Class<? extends T> defaultClass) {
        try {
            return ServiceFactory.createService(serviceClass);
        }
        catch (TentackleRuntimeException re) {
            try {
                Logger.getLogger(ServiceFactory.class.getName()).log(Level.WARNING, "creating service for " + serviceClass.getName() + " failed -> creating default " + defaultClass.getName(), re);
                return defaultClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new TentackleRuntimeException("cannot create default instance " + defaultClass + " for " + serviceClass, ex);
            }
        }
    }

    public static ClassLoader getClassLoader(String servicePath, String serviceName) {
        return INSTANCE.getClassLoaderImpl(servicePath, serviceName);
    }

    public static ClassLoader getExplicitClassLoader(String servicePath, String serviceName) {
        if (INSTANCE != null) {
            return INSTANCE.getExplicitClassLoaderImpl(servicePath, serviceName);
        }
        return null;
    }

    public static void addExplicitClassLoader(String servicePath, String serviceName, ClassLoader classLoader) {
        INSTANCE.addExplicitClassLoaderImpl(servicePath, serviceName, classLoader);
    }

    public static void removeExplicitClassLoader(String servicePath, String serviceName, ClassLoader classLoader) {
        INSTANCE.removeExplicitClassLoaderImpl(servicePath, serviceName, classLoader);
    }

    public static void applyResourceIndex(ClassLoader classLoader, String indexName, boolean set) {
        INSTANCE.applyResourceIndexImpl(classLoader, indexName, set);
    }

    public ServiceFactory() {
        try {
            this.serviceFinderClass = new DefaultServiceFinder().findFirstServiceProvider(ServiceFinder.class);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ServiceFactory.class.getName()).log(Level.INFO, "cannot load ServiceFinder class -> fallback to " + DefaultServiceFinder.class.getName(), ex);
            this.serviceFinderClass = DefaultServiceFinder.class;
        }
        this.finderMap = new ConcurrentHashMap<ServiceFinderKey, ServiceFinder>();
        this.explicitLoaders = new HashMap<ClassLoaderKey, LinkedList<ClassLoader>>();
    }

    public ClassLoader getFixedClassLoader() {
        return this.fixedClassLoader;
    }

    public void setFixedClassLoader(ClassLoader classLoader) {
        this.fixedClassLoader = classLoader;
    }

    protected ClassLoader getClassLoader() {
        ClassLoader loader = this.fixedClassLoader;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        return loader;
    }

    protected ClassLoader getClassLoaderImpl(String servicePath, String serviceName) {
        ClassLoader cl = ServiceFactory.getExplicitClassLoader(servicePath, serviceName);
        if (cl == null) {
            cl = this.getClassLoader();
        }
        return cl;
    }

    protected synchronized ClassLoader getExplicitClassLoaderImpl(String servicePath, String serviceName) {
        ClassLoader cl = null;
        LinkedList<ClassLoader> cList = this.explicitLoaders.get(new ClassLoaderKey(servicePath, serviceName));
        if (cList != null && !cList.isEmpty()) {
            cl = cList.getFirst();
        }
        return cl;
    }

    protected synchronized void addExplicitClassLoaderImpl(String servicePath, String serviceName, ClassLoader classLoader) {
        ClassLoaderKey key = new ClassLoaderKey(servicePath, serviceName);
        LinkedList loaders = this.explicitLoaders.computeIfAbsent(key, k -> new LinkedList());
        loaders.remove(classLoader);
        loaders.push(classLoader);
    }

    protected synchronized void removeExplicitClassLoaderImpl(String servicePath, String serviceName, ClassLoader classLoader) {
        ClassLoaderKey key = new ClassLoaderKey(servicePath, serviceName);
        LinkedList<ClassLoader> loaders = this.explicitLoaders.get(key);
        if (loaders != null) {
            loaders.remove(classLoader);
            if (loaders.isEmpty()) {
                this.explicitLoaders.remove(key);
            }
        }
    }

    protected void applyResourceIndexImpl(ClassLoader classLoader, String indexName, boolean set) {
        block11: {
            try {
                Enumeration<URL> urls = classLoader.getResources(indexName);
                if (!urls.hasMoreElements()) break block11;
                URL url = urls.nextElement();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String serviceName;
                        String servicePath;
                        if (line.startsWith("#")) continue;
                        int ndx = line.lastIndexOf(47);
                        if (ndx > 0 && ndx < line.length() - 1) {
                            servicePath = line.substring(0, ndx + 1);
                            serviceName = line.substring(ndx + 1);
                        } else {
                            servicePath = "";
                            serviceName = line;
                        }
                        if (set) {
                            ServiceFactory.addExplicitClassLoader(servicePath, serviceName, classLoader);
                            continue;
                        }
                        ServiceFactory.removeExplicitClassLoader(servicePath, serviceName, classLoader);
                    }
                }
            }
            catch (IOException ix) {
                throw new TentackleRuntimeException("applying index failed", ix);
            }
        }
    }

    public Map<ServiceFinderKey, ServiceFinder> getFinderMap() {
        return this.finderMap;
    }

    protected Class<? extends ServiceFinder> getServiceFinderClass() {
        return this.serviceFinderClass;
    }

    protected ServiceFinder getServiceFinderImpl(ClassLoader loader, String servicePath) {
        ServiceFinderKey key = new ServiceFinderKey(loader, servicePath);
        ServiceFinder finder = this.getFinderMap().get(key);
        if (finder == null) {
            try {
                finder = this.getServiceFinderClass().getConstructor(ClassLoader.class, String.class).newInstance(loader, servicePath);
                this.getFinderMap().put(key, finder);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new TentackleRuntimeException("cannot instantiate service finder", ex);
            }
        }
        return finder;
    }

    protected ServiceFinder getServiceFinderImpl(String servicePath) {
        return this.getServiceFinderImpl(this.getClassLoader(), servicePath);
    }

    protected ServiceFinder getServiceFinderImpl() {
        return this.getServiceFinderImpl("META-INF/services/");
    }

    static {
        INSTANCE = ServiceFactory.createServiceFactory();
    }

    private static class ClassLoaderKey {
        private final String servicePath;
        private final String serviceName;

        public ClassLoaderKey(String servicePath, String serviceName) {
            this.servicePath = servicePath;
            this.serviceName = serviceName;
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + Objects.hashCode(this.servicePath);
            hash = 37 * hash + Objects.hashCode(this.serviceName);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassLoaderKey other = (ClassLoaderKey)obj;
            if (!Objects.equals(this.servicePath, other.servicePath)) {
                return false;
            }
            return Objects.equals(this.serviceName, other.serviceName);
        }
    }
}

