/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import org.tentackle.common.Freezable;
import org.tentackle.common.TentackleRuntimeException;

public class Time
extends java.sql.Time
implements Freezable {
    private static final long serialVersionUID = 8397324403548013688L;
    private boolean frozen;
    private transient Calendar cal;

    public static Time createFrozen(long epoch) {
        Time time = new Time(epoch);
        time.freeze();
        return time;
    }

    public Time(long time) {
        super(time);
    }

    public Time() {
        this(System.currentTimeMillis());
    }

    @Override
    public Time clone() {
        Time time = (Time)super.clone();
        time.frozen = false;
        return time;
    }

    public Calendar getCalendar() {
        if (this.cal == null) {
            this.cal = Calendar.getInstance();
            this.cal.setTime(this);
        }
        return this.cal;
    }

    @Override
    public void freeze() {
        this.frozen = true;
    }

    @Override
    public void setTime(long time) {
        this.assertNotFrozen();
        super.setTime(time);
        this.cal = null;
    }

    @Override
    @Deprecated
    public void setYear(int year) {
        this.assertNotFrozen();
        super.setYear(year);
    }

    @Override
    @Deprecated
    public void setMonth(int month) {
        this.assertNotFrozen();
        super.setMonth(month);
    }

    @Override
    @Deprecated
    public void setDate(int date) {
        this.assertNotFrozen();
        super.setDate(date);
    }

    @Override
    @Deprecated
    public void setHours(int hours) {
        this.assertNotFrozen();
        super.setHours(hours);
    }

    @Override
    @Deprecated
    public void setMinutes(int minutes) {
        this.assertNotFrozen();
        super.setMinutes(minutes);
    }

    @Override
    @Deprecated
    public void setSeconds(int seconds) {
        this.assertNotFrozen();
        super.setSeconds(seconds);
    }

    private void assertNotFrozen() {
        if (this.frozen) {
            throw new TentackleRuntimeException("time is frozen");
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeByte(this.getCalendar().get(11));
        s.writeByte(this.getCalendar().get(12));
        s.writeByte(this.getCalendar().get(13));
        s.writeShort(this.getCalendar().get(14));
        s.writeBoolean(this.frozen);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        byte hours = s.readByte();
        byte minutes = s.readByte();
        byte seconds = s.readByte();
        short millis = s.readShort();
        this.cal = Calendar.getInstance();
        this.cal.set(1970, 0, 1, hours, minutes, seconds);
        this.cal.set(14, millis);
        super.setTime(this.cal.getTimeInMillis());
        this.frozen = s.readBoolean();
    }
}

