/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.tentackle.common.Freezable;
import org.tentackle.common.TentackleRuntimeException;

public class Binary<T extends Serializable>
implements Serializable,
Cloneable,
Freezable {
    private static final long serialVersionUID = 5853122168291704220L;
    private static final int INITIAL_SIZE = 1024;
    private byte[] data;
    private int length;
    private Integer hash;
    private boolean frozen;
    private transient T object;

    public Binary(T object) throws IOException {
        this.setObject(object);
    }

    public Binary() {
    }

    @Override
    public void freeze() {
        this.frozen = true;
    }

    public Binary<T> clone() {
        Binary binary;
        try {
            binary = (Binary)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
        if (binary.data != null) {
            binary.data = new byte[this.length];
            System.arraycopy(this.data, 0, binary.data, 0, this.length);
        }
        binary.frozen = false;
        return binary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binary binary = (Binary)o;
        return Arrays.equals(this.data, binary.data);
    }

    public int hashCode() {
        if (this.hash == null) {
            this.hash = Arrays.hashCode(this.data);
        }
        return this.hash;
    }

    public static <T extends Serializable> Binary<T> createBinary(InputStream stream, int bufSize, boolean frozen) throws IOException {
        if (stream == null) {
            return null;
        }
        try (InputStream inputStream = stream;){
            int count;
            Binary<T> b = new Binary<T>();
            if (bufSize <= 0) {
                bufSize = 1024;
            }
            b.data = new byte[bufSize];
            while ((count = stream.read(b.data, b.length, bufSize - b.length)) >= 0) {
                b.length += count;
                if (b.length != bufSize) continue;
                byte[] oldData = b.data;
                b.data = new byte[bufSize <<= 1];
                System.arraycopy(oldData, 0, b.data, 0, b.length);
            }
            if (frozen) {
                b.freeze();
            }
            Binary<T> binary = b.length == 0 ? null : b;
            return binary;
        }
    }

    public int getLength() {
        return this.length;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public T getObject() throws IOException, ClassNotFoundException {
        if (this.object == null && this.data != null) {
            try (ObjectInputStream is = new ObjectInputStream(this.getInputStream());){
                this.object = (Serializable)is.readObject();
            }
        }
        return this.object;
    }

    public void setObject(T object) throws IOException {
        this.assertNotfrozen();
        this.object = object;
        this.hash = null;
        if (object == null) {
            this.data = null;
            this.length = 0;
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (ObjectOutputStream os = new ObjectOutputStream(bos);){
                os.writeObject(object);
                os.flush();
                this.data = bos.toByteArray();
                this.length = bos.size();
            }
        }
    }

    private void assertNotfrozen() {
        if (this.frozen) {
            throw new TentackleRuntimeException("binary is frozen");
        }
    }
}

