/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.util.Locale;
import java.util.function.Function;
import org.tentackle.common.StringHelper;

public class DefaultStringNormalizer
implements Function<String, String> {
    private static final char WORD_SEPARATOR = ' ';
    private final char fieldSeparator;

    public DefaultStringNormalizer(char fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public DefaultStringNormalizer() {
        this(',');
    }

    @Override
    public String apply(String str) {
        if ((str = StringHelper.unDiacrit(str, false)) != null) {
            char c;
            int i;
            str = str.toUpperCase(Locale.ENGLISH);
            int len = str.length();
            StringBuilder sb = new StringBuilder(len);
            boolean lastCharWasSpace = false;
            boolean lastCharWasFieldSeparator = false;
            for (i = 0; i < len; ++i) {
                c = str.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    lastCharWasSpace = false;
                    lastCharWasFieldSeparator = false;
                } else if (c == this.fieldSeparator && c != '\u0000') {
                    if (lastCharWasFieldSeparator) continue;
                    lastCharWasFieldSeparator = true;
                    lastCharWasSpace = false;
                } else {
                    if (lastCharWasSpace) continue;
                    lastCharWasSpace = true;
                    lastCharWasFieldSeparator = false;
                    c = ' ';
                }
                if (i + 2 < len && c == 'S' && str.charAt(i + 1) == 'C' && str.charAt(i + 2) == 'H') {
                    i += 2;
                }
                if (i + 1 < len) {
                    if (c == 'C' && str.charAt(i + 1) == 'H') {
                        c = 'K';
                        ++i;
                    } else if (c == 'C' && str.charAt(i + 1) == 'K') {
                        c = 'K';
                        ++i;
                    } else if (c == 'P' && str.charAt(i + 1) == 'H') {
                        c = 'F';
                        ++i;
                    } else if (c == 'T' && str.charAt(i + 1) == 'H') {
                        c = 'T';
                        ++i;
                    }
                }
                switch (c) {
                    case 'D': {
                        c = 'T';
                        break;
                    }
                    case 'G': {
                        c = 'K';
                        break;
                    }
                    case 'C': {
                        c = 'K';
                        break;
                    }
                    case 'Y': {
                        c = 'I';
                        break;
                    }
                    case 'B': {
                        c = 'P';
                        break;
                    }
                    case 'Q': {
                        c = 'K';
                        break;
                    }
                    case 'W': {
                        c = 'V';
                        break;
                    }
                    case 'Z': {
                        c = 'S';
                        break;
                    }
                }
                sb.append(c);
            }
            len = sb.length();
            for (i = 0; i < len; ++i) {
                int c3;
                c = sb.charAt(i);
                if (i + 1 < len) {
                    if (c == 'A' && sb.charAt(i + 1) == 'I') {
                        sb.setCharAt(i, 'E');
                    }
                    if (Character.isLetter(c) && c == sb.charAt(i + 1)) {
                        sb.deleteCharAt(i + 1);
                        --len;
                        continue;
                    }
                    if (c == 'I' && sb.charAt(i + 1) == 'E') {
                        sb.deleteCharAt(i + 1);
                        --len;
                        continue;
                    }
                }
                if (i + 1 >= len) continue;
                char c2 = sb.charAt(i + 1);
                int n = c3 = i + 2 < len ? (int)sb.charAt(i + 2) : 32;
                if (c != 'A' && c != 'E' && c != 'I' && c != 'O' && c != 85 || c2 != 'H' || c3 == 65 && c3 == 69 && c3 == 73 && c3 == 79 && c3 == 85) continue;
                sb.deleteCharAt(i + 1);
                --len;
            }
            len = sb.length();
            if (len > 0) {
                StringBuilder fb = new StringBuilder(len);
                for (int i2 = 0; i2 < len; ++i2) {
                    char c2 = sb.charAt(i2);
                    if (c2 == ' ') continue;
                    fb.append(c2);
                }
                return fb.toString();
            }
            return "";
        }
        return null;
    }
}

